/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.util;

import java.text.BreakIterator;
import org.apiguardian.api.API;

@API(since="5.5", status=API.Status.EXPERIMENTAL)
public class StringWrap {
    private final int minWrap;
    private final int maxWrap;
    private final BreakCursor wordCursor = new BreakCursor(BreakIterator.getLineInstance());
    private final BreakCursor charCursor = new BreakCursor(BreakIterator.getCharacterInstance());

    public StringWrap(int minWrap, int maxWrap) {
        this.minWrap = minWrap;
        this.maxWrap = maxWrap;
    }

    public int getMinWrap() {
        return this.minWrap;
    }

    public int getMaxWrap() {
        return this.maxWrap;
    }

    public String wrap(String input, String delimiter) {
        if (input.length() <= this.minWrap) {
            return input;
        }
        this.wordCursor.setText(input);
        this.charCursor.setText(input);
        int pos = 0;
        StringBuilder sb = new StringBuilder(input.length() + input.length() / this.minWrap * delimiter.length());
        boolean hasChanges = false;
        int nextLineSeparator = -2;
        while (input.length() - pos > this.maxWrap) {
            int next;
            if (nextLineSeparator != -1 && nextLineSeparator < pos) {
                nextLineSeparator = input.indexOf(10, pos);
            }
            if ((next = nextLineSeparator) != -1 && pos - next <= this.maxWrap) {
                sb.append(input, pos, ++next);
                pos = next;
                continue;
            }
            int startWrap = pos + this.minWrap - 1;
            int endWrap = pos + this.maxWrap;
            if (this.wordCursor.advance(startWrap, endWrap)) {
                next = this.wordCursor.getPos();
            } else {
                this.charCursor.advance(startWrap, endWrap);
                next = this.charCursor.getPos();
                if (next == -1 || next == input.length()) break;
            }
            sb.append(input, pos, next);
            sb.append(delimiter);
            hasChanges = true;
            pos = next;
        }
        this.wordCursor.setText("");
        this.charCursor.setText("");
        if (!hasChanges) {
            return input;
        }
        if (pos != input.length()) {
            sb.append(input, pos, input.length());
        }
        return sb.toString();
    }

    private static class BreakCursor {
        private static final int UNINITIALIZED = -2;
        private final BreakIterator iterator;
        private int pos;
        private int next;

        BreakCursor(BreakIterator iterator) {
            this.iterator = iterator;
        }

        void setText(String text) {
            this.iterator.setText(text);
            this.pos = 0;
            this.next = -2;
        }

        public int getPos() {
            return this.pos;
        }

        public boolean advance(int startWrap, int endWrap) {
            if (this.pos == -1 || this.pos > endWrap) {
                return false;
            }
            int n = this.pos = this.next != -2 ? this.next : this.iterator.following(startWrap);
            if (this.pos == -1 || this.pos > endWrap) {
                return false;
            }
            while (true) {
                this.next = this.iterator.next();
                if (this.next == -1 || this.next > endWrap) break;
                this.pos = this.next;
            }
            return true;
        }
    }
}

