/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler.hc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.entity.DeflateInputStream;

public class LaxDeflateInputStream
extends DeflateInputStream {
    private final boolean relax;

    public LaxDeflateInputStream(InputStream wrapped, boolean relax) throws IOException {
        super(wrapped);
        this.relax = relax;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return super.read(b, off, len);
        }
        catch (EOFException ex) {
            return this.handleRelaxMode(ex, this.relax);
        }
    }

    public int read() throws IOException {
        try {
            return super.read();
        }
        catch (EOFException ex) {
            return this.handleRelaxMode(ex, this.relax);
        }
    }

    public int read(byte[] b) throws IOException {
        try {
            return super.read(b);
        }
        catch (EOFException ex) {
            return this.handleRelaxMode(ex, this.relax);
        }
    }

    private int handleRelaxMode(EOFException ex, boolean relaxMode) throws EOFException {
        if (relaxMode) {
            return -1;
        }
        throw ex;
    }
}

