/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.config.GraphQLRequestParams;
import org.apache.jmeter.protocol.http.config.MultipartUrlConfig;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.gui.GraphQLHTTPSamplerGui;
import org.apache.jmeter.protocol.http.control.gui.HttpTestSampleGui;
import org.apache.jmeter.protocol.http.proxy.AbstractSamplerCreator;
import org.apache.jmeter.protocol.http.proxy.HttpRequestHdr;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.protocol.http.sampler.PostWriter;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jmeter.protocol.http.util.GraphQLRequestParamUtils;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultSamplerCreator
extends AbstractSamplerCreator {
    private static final Logger log = LoggerFactory.getLogger(DefaultSamplerCreator.class);
    private static final int SAMPLER_NAME_NAMING_MODE_PREFIX = 0;
    private static final int SAMPLER_NAME_NAMING_MODE_COMPLETE = 1;
    private static final int SAMPLER_NAME_NAMING_MODE_SUFFIX = 2;
    private static final int SAMPLER_NAME_NAMING_MODE_FORMATTER = 3;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Override
    public String[] getManagedContentTypes() {
        return new String[0];
    }

    @Override
    public HTTPSamplerBase createSampler(HttpRequestHdr request, Map<String, String> pageEncodings, Map<String, String> formEncodings) {
        HTTPSamplerBase sampler = HTTPSamplerFactory.newInstance(request.getHttpSamplerName());
        sampler.setProperty("TestElement.gui_class", HttpTestSampleGui.class.getName());
        sampler.setFollowRedirects(false);
        sampler.setUseKeepAlive(true);
        if (log.isDebugEnabled()) {
            log.debug("getSampler: sampler path = {}", (Object)sampler.getPath());
        }
        return sampler;
    }

    @Override
    public final void populateSampler(HTTPSamplerBase sampler, HttpRequestHdr request, Map<String, String> pageEncodings, Map<String, String> formEncodings) throws Exception {
        Arguments arguments;
        this.computeFromHeader(sampler, request, pageEncodings, formEncodings);
        this.computeFromPostBody(sampler, request);
        if (log.isDebugEnabled()) {
            log.debug("sampler path = {}", (Object)sampler.getPath());
        }
        if ((arguments = sampler.getArguments()).getArgumentCount() == 1 && arguments.getArgument(0).getName().length() == 0) {
            sampler.setPostBodyRaw(true);
        }
        if (request.isDetectGraphQLRequest()) {
            this.detectAndModifySamplerOnGraphQLRequest(sampler, request);
        }
    }

    private void detectAndModifySamplerOnGraphQLRequest(HTTPSamplerBase sampler, HttpRequestHdr request) {
        String method = request.getMethod();
        Header header = request.getHeaderManager().getFirstHeaderNamed("Content-Type");
        boolean graphQLContentType = header != null && GraphQLRequestParamUtils.isGraphQLContentType(header.getValue());
        GraphQLRequestParams params = null;
        if ("POST".equals(method) && graphQLContentType) {
            try {
                byte[] postData = request.getRawPostData();
                if (postData != null && postData.length > 0) {
                    params = GraphQLRequestParamUtils.toGraphQLRequestParams(request.getRawPostData(), sampler.getContentEncoding());
                }
            }
            catch (Exception e) {
                log.debug("Ignoring request, '{}' as it's not a valid GraphQL post data.", (Object)request);
            }
        } else if ("GET".equals(method)) {
            try {
                params = GraphQLRequestParamUtils.toGraphQLRequestParams(sampler.getArguments(), sampler.getContentEncoding());
            }
            catch (Exception e) {
                log.debug("Ignoring request, '{}' as it does not valid GraphQL arguments.", (Object)request);
            }
        }
        if (params != null) {
            sampler.setProperty("TestElement.gui_class", GraphQLHTTPSamplerGui.class.getName());
            sampler.setProperty("GraphQLHTTPSampler.operationName", params.getOperationName());
            sampler.setProperty("GraphQLHTTPSampler.query", params.getQuery());
            sampler.setProperty("GraphQLHTTPSampler.variables", params.getVariables());
        }
    }

    protected void computeFromHeader(HTTPSamplerBase sampler, HttpRequestHdr request, Map<String, String> pageEncodings, Map<String, String> formEncodings) throws Exception {
        this.computeDomain(sampler, request);
        this.computeMethod(sampler, request);
        this.computePort(sampler, request);
        this.computeProtocol(sampler, request);
        this.computeContentEncoding(sampler, request, pageEncodings, formEncodings);
        this.computePath(sampler, request);
        this.computeSamplerName(sampler, request);
    }

    protected void computeFromPostBody(HTTPSamplerBase sampler, HttpRequestHdr request) throws Exception {
        if (!"CONNECT".equals(request.getMethod()) && !"GET".equals(request.getMethod())) {
            String contentType = request.getContentType();
            MultipartUrlConfig urlConfig = request.getMultipartConfig(contentType);
            String contentEncoding = sampler.getContentEncoding();
            String postData = null;
            if (log.isDebugEnabled()) {
                if (!StringUtils.isEmpty((CharSequence)contentEncoding)) {
                    log.debug("Using encoding {} for request body", (Object)contentEncoding);
                } else {
                    log.debug("No encoding found, using JRE default encoding for request body");
                }
            }
            postData = !StringUtils.isEmpty((CharSequence)contentEncoding) ? new String(request.getRawPostData(), contentEncoding) : new String(request.getRawPostData(), PostWriter.ENCODING);
            if (urlConfig != null) {
                urlConfig.parseArguments(postData);
                sampler.setDoMultipart(true);
                request.getHeaderManager().removeHeaderNamed("content-type");
                request.getHeaderManager().removeHeaderNamed("content-length");
                sampler.setArguments(urlConfig.getArguments());
                sampler.setHTTPFiles(urlConfig.getHTTPFileArgs().asArray());
                sampler.setDoBrowserCompatibleMultipart(true);
            } else if (postData.trim().startsWith("<?") || "PUT".equals(sampler.getMethod()) || DefaultSamplerCreator.isPotentialXml(postData) || DefaultSamplerCreator.isPotentialJson(postData)) {
                sampler.addNonEncodedArgument("", postData, "");
            } else if (contentType == null || contentType.startsWith("application/x-www-form-urlencoded") && !this.isBinaryContent(contentType)) {
                sampler.parseArguments(postData.trim(), contentEncoding);
            } else if (postData.length() > 0) {
                if (this.isBinaryContent(contentType)) {
                    try {
                        File tempDir = new File(this.getBinaryDirectory());
                        File out = File.createTempFile(request.getMethod(), this.getBinaryFileSuffix(), tempDir);
                        FileUtils.writeByteArrayToFile((File)out, (byte[])request.getRawPostData());
                        HTTPFileArg[] files = new HTTPFileArg[]{new HTTPFileArg(out.getPath(), "", contentType)};
                        sampler.setHTTPFiles(files);
                    }
                    catch (IOException e) {
                        log.warn("Could not create binary file: {}", (Throwable)e);
                    }
                } else {
                    sampler.addNonEncodedArgument("", postData, "");
                }
            }
        }
    }

    public static boolean isPotentialJson(String postData) {
        boolean valid = true;
        try {
            OBJECT_MAPPER.readTree(postData);
        }
        catch (JsonProcessingException e) {
            valid = false;
        }
        log.debug("Is Post data {} JSON ? {}", (Object)postData, (Object)valid);
        return valid;
    }

    private static boolean isPotentialXml(String postData) {
        boolean isXml;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            ErrorDetectionHandler detectionHandler = new ErrorDetectionHandler();
            xmlReader.setContentHandler(detectionHandler);
            xmlReader.setErrorHandler(detectionHandler);
            xmlReader.parse(new InputSource(new StringReader(postData)));
            isXml = !detectionHandler.isErrorDetected();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            isXml = false;
        }
        log.debug("Is Post data {} XML ? {}", (Object)postData, (Object)isXml);
        return isXml;
    }

    protected void computeSamplerName(HTTPSamplerBase sampler, HttpRequestHdr request) {
        String prefix = StringUtils.defaultString((String)request.getPrefix(), (String)"");
        int httpSampleNameMode = request.getHttpSampleNameMode();
        String format = this.getFormat(httpSampleNameMode, request.getHttpSampleNameFormat());
        if (!"CONNECT".equals(request.getMethod()) && DefaultSamplerCreator.isNumberRequests()) {
            sampler.setName(MessageFormat.format(format, prefix, sampler.getPath(), DefaultSamplerCreator.incrementRequestNumberAndGet()));
        } else {
            sampler.setName(MessageFormat.format(format, prefix, sampler.getPath()));
        }
    }

    private String getFormat(int httpSampleNameMode, String format) {
        if (httpSampleNameMode == 3) {
            return format.replaceAll("#\\{name([,}])", "{0$1").replaceAll("#\\{path([,}])", "{1$1").replaceAll("#\\{counter([,}])", "{2$1");
        }
        if (DefaultSamplerCreator.isNumberRequests()) {
            return this.getNumberedFormat(httpSampleNameMode);
        }
        if (httpSampleNameMode == 0) {
            return "{0}{1}";
        }
        if (httpSampleNameMode == 1) {
            return "{0}";
        }
        if (httpSampleNameMode == 2) {
            return "{0} {1}";
        }
        return "{1}";
    }

    private String getNumberedFormat(int httpSampleNameMode) {
        if (httpSampleNameMode == 0) {
            return "{0}{1}-{2}";
        }
        if (httpSampleNameMode == 1) {
            return "{0}-{2}";
        }
        if (httpSampleNameMode == 2) {
            return "{0}-{2} {1}";
        }
        return "{1}";
    }

    protected void computePath(HTTPSamplerBase sampler, HttpRequestHdr request) {
        if (sampler.getContentEncoding() != null) {
            sampler.setPath(request.getPath(), sampler.getContentEncoding());
        } else {
            sampler.setPath(request.getPath(), null);
        }
        if (log.isDebugEnabled()) {
            log.debug("Proxy: setting path: {}", (Object)sampler.getPath());
        }
    }

    protected void computeContentEncoding(HTTPSamplerBase sampler, HttpRequestHdr request, Map<String, String> pageEncodings, Map<String, String> formEncodings) throws MalformedURLException {
        URL pageUrl = sampler.isProtocolDefaultPort() ? new URL(sampler.getProtocol(), sampler.getDomain(), request.getPath()) : new URL(sampler.getProtocol(), sampler.getDomain(), sampler.getPort(), request.getPath());
        String urlWithoutQuery = request.getUrlWithoutQuery(pageUrl);
        String contentEncoding = this.computeContentEncoding(request, pageEncodings, formEncodings, urlWithoutQuery);
        if (!StringUtils.isEmpty((CharSequence)contentEncoding)) {
            sampler.setContentEncoding(contentEncoding);
        }
    }

    protected String computeContentEncoding(HttpRequestHdr request, Map<String, String> pageEncodings, Map<String, String> formEncodings, String urlWithoutQuery) {
        String contentEncoding;
        String requestContentEncoding = ConversionUtils.getEncodingFromContentType(request.getContentType());
        if (requestContentEncoding != null) {
            contentEncoding = requestContentEncoding;
        } else {
            contentEncoding = pageEncodings.get(urlWithoutQuery);
            log.debug("Computed encoding:{} for url:{}", (Object)contentEncoding, (Object)urlWithoutQuery);
            String formEncoding = formEncodings.get(urlWithoutQuery);
            if (formEncoding != null) {
                contentEncoding = formEncoding;
                log.debug("Computed encoding:{} for url:{}", (Object)contentEncoding, (Object)urlWithoutQuery);
            }
        }
        if (contentEncoding == null) {
            contentEncoding = pageEncodings.get("__defaultEncoding");
            log.debug("Defaulting to encoding:{} for url:{}", (Object)contentEncoding, (Object)urlWithoutQuery);
        }
        return contentEncoding;
    }

    protected void computeProtocol(HTTPSamplerBase sampler, HttpRequestHdr request) {
        sampler.setProtocol(request.getProtocol(sampler));
    }

    protected void computePort(HTTPSamplerBase sampler, HttpRequestHdr request) {
        sampler.setPort(request.serverPort());
        if (log.isDebugEnabled()) {
            log.debug("Proxy: setting port: {}", (Object)Integer.toString(sampler.getPort()));
        }
    }

    protected void computeMethod(HTTPSamplerBase sampler, HttpRequestHdr request) {
        sampler.setMethod(request.getMethod());
        log.debug("Proxy: setting method: {}", (Object)sampler.getMethod());
    }

    protected void computeDomain(HTTPSamplerBase sampler, HttpRequestHdr request) {
        sampler.setDomain(request.serverName());
        if (log.isDebugEnabled()) {
            log.debug("Proxy: setting server: {}", (Object)sampler.getDomain());
        }
    }

    private static final class ErrorDetectionHandler
    extends DefaultHandler {
        private boolean errorDetected = false;

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.errorDetected = true;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.errorDetected = true;
        }

        public boolean isErrorDetected() {
            return this.errorDetected;
        }
    }
}

