/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.backend.BackendListenerClient;
import org.apache.jmeter.visualizers.backend.BackendListenerContext;
import org.apache.jmeter.visualizers.backend.SamplerMetric;
import org.apache.jmeter.visualizers.backend.UserMetric;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractBackendListenerClient
implements BackendListenerClient {
    private static final Logger LOGGER = LoggingManager.getLoggerForClass();
    private UserMetric userMetrics = new UserMetric();
    private ConcurrentHashMap<String, SamplerMetric> metricsPerSampler = new ConcurrentHashMap();

    @Override
    public void setupTest(BackendListenerContext context) throws Exception {
        LOGGER.debug(this.getClass().getName() + ": setupTest");
    }

    @Override
    public void teardownTest(BackendListenerContext context) throws Exception {
        LOGGER.debug(this.getClass().getName() + ": teardownTest");
        this.metricsPerSampler.clear();
    }

    @Override
    public Arguments getDefaultParameters() {
        return null;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public SampleResult createSampleResult(BackendListenerContext context, SampleResult result) {
        return result;
    }

    protected final SamplerMetric getSamplerMetric(String sampleLabel) {
        SamplerMetric oldValue;
        SamplerMetric samplerMetric = this.metricsPerSampler.get(sampleLabel);
        if (samplerMetric == null && (oldValue = this.metricsPerSampler.putIfAbsent(sampleLabel, samplerMetric = new SamplerMetric())) != null) {
            samplerMetric = oldValue;
        }
        return samplerMetric;
    }

    protected Map<String, SamplerMetric> getMetricsPerSampler() {
        return this.metricsPerSampler;
    }

    protected UserMetric getUserMetrics() {
        return this.userMetrics;
    }
}

