/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.json.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONManager {
    private static final Configuration DEFAULT_CONFIGURATION = Configuration.defaultConfiguration().addOptions(new Option[]{Option.ALWAYS_RETURN_LIST});
    private Map<String, JsonPath> expressionToJsonPath = new HashMap<String, JsonPath>(2);

    private JsonPath getJsonPath(String jsonPathExpression) {
        JsonPath jsonPath = this.expressionToJsonPath.get(jsonPathExpression);
        if (jsonPath == null) {
            jsonPath = JsonPath.compile((String)jsonPathExpression, (Predicate[])new Predicate[0]);
            this.expressionToJsonPath.put(jsonPathExpression, jsonPath);
        }
        return jsonPath;
    }

    public void reset() {
        this.expressionToJsonPath.clear();
    }

    public List<Object> extractWithJsonPath(String jsonString, String jsonPath) throws ParseException {
        JsonPath jsonPathParser = this.getJsonPath(jsonPath);
        return (List)jsonPathParser.read(jsonString, DEFAULT_CONFIGURATION);
    }
}

