/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.mem.results;

import com.hp.hpl.jena.query.Dataset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.jena.jdbc.mem.connections.DebugMemConnection;
import org.apache.jena.jdbc.results.AbstractResultSetTests;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class AbstractMemResultSetTests
extends AbstractResultSetTests {
    protected static DebugMemConnection connection;

    @BeforeClass
    public static void setup() throws SQLException {
        connection = new DebugMemConnection();
        connection.setJdbcCompatibilityLevel(9);
    }

    @AfterClass
    public static void teardown() throws SQLException {
        connection.close();
    }

    protected abstract Dataset prepareDataset(Dataset var1) throws SQLException;

    protected final ResultSet createResults(Dataset ds, String query) throws SQLException {
        return this.createResults(ds, query, 1003);
    }

    protected final ResultSet createResults(Dataset ds, String query, int resultSetType) throws SQLException {
        connection.setJenaDataset(this.prepareDataset(ds));
        Statement stmt = connection.createStatement(resultSetType, 1007);
        return stmt.executeQuery(query);
    }
}

