/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.modify.UsingList;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateException;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_Protocol;
import org.apache.jena.iri.IRI;
import org.apache.jena.riot.system.IRIResolver;

public class SPARQL_Update
extends SPARQL_Protocol {
    private static final String UpdateParseBase = "http://example/update-base/";
    private static final IRIResolver resolver = IRIResolver.create((String)"http://example/update-base/");
    protected static List<String> paramsForm = Arrays.asList("request", "update", "using-graph-uri", "using-named-graph-uri");
    protected static List<String> paramsPOST = Arrays.asList("using-graph-uri", "using-named-graph-uri");

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(400, "Attempt to perform SPARQL update by GET.  Use POST");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doCommon(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        SPARQL_Update.setCommonHeadersForOptions(response);
        response.setHeader("Allow", "OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    @Override
    protected void perform(HttpAction action) {
        ContentType ct = FusekiLib.getContentType(action);
        String ctStr = ct == null ? "application/sparql-update" : ct.getContentType();
        if ("application/sparql-update".equals(ctStr)) {
            this.executeBody(action);
            return;
        }
        if ("application/x-www-form-urlencoded".equals(ctStr)) {
            this.executeForm(action);
            return;
        }
        SPARQL_Update.error(415, "Bad content type: " + action.request.getContentType());
    }

    @Override
    protected void validate(HttpAction action) {
        ContentType incoming;
        String ctStr;
        HttpServletRequest request = action.request;
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            SPARQL_Update.errorMethodNotAllowed("SPARQL Update : use POST");
        }
        String string = ctStr = (incoming = FusekiLib.getContentType(action)) == null ? "application/sparql-update" : incoming.getContentType();
        if ("application/sparql-update".equals(ctStr)) {
            String charset = request.getCharacterEncoding();
            if (charset != null && !charset.equalsIgnoreCase("utf-8")) {
                SPARQL_Update.errorBadRequest("Bad charset: " + charset);
            }
            this.validate(request, paramsPOST);
            return;
        }
        if ("application/x-www-form-urlencoded".equals(ctStr)) {
            String requestStr;
            int x = SPARQL_Update.countParamOccurences(request, "update") + SPARQL_Update.countParamOccurences(request, "request");
            if (x == 0) {
                SPARQL_Update.errorBadRequest("SPARQL Update: No 'update=' parameter");
            }
            if (x != 1) {
                SPARQL_Update.errorBadRequest("SPARQL Update: Multiple 'update=' parameters");
            }
            if ((requestStr = request.getParameter("update")) == null) {
                requestStr = request.getParameter("request");
            }
            if (requestStr == null) {
                SPARQL_Update.errorBadRequest("SPARQL Update: No update= in HTML form");
            }
            this.validate(request, paramsForm);
            return;
        }
        SPARQL_Update.error(415, "Must be application/sparql-update or application/x-www-form-urlencoded (got " + ctStr + ")");
    }

    protected void validate(HttpServletRequest request, Collection<String> params) {
        if (params != null) {
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                if (params.contains(name)) continue;
                SPARQL_Update.warning("SPARQL Update: Unrecognize request parameter (ignored): " + name);
            }
        }
    }

    private void executeBody(HttpAction action) {
        Object input = null;
        try {
            input = action.request.getInputStream();
        }
        catch (IOException ex) {
            SPARQL_Update.errorOccurred(ex);
        }
        if (action.verbose) {
            String requestStr = null;
            try {
                requestStr = IO.readWholeFileAsUTF8((InputStream)input);
            }
            catch (IOException ex) {
                IO.exception((IOException)ex);
            }
            Fuseki.requestLog.info(String.format("[%d] Update = %s", action.id, SPARQL_Update.formatForLog(requestStr)));
            input = new ByteArrayInputStream(requestStr.getBytes());
            Object var3_4 = null;
        }
        this.execute(action, (InputStream)input);
        SPARQL_Update.successNoContent(action);
    }

    private void executeForm(HttpAction action) {
        String requestStr = action.request.getParameter("update");
        if (requestStr == null) {
            requestStr = action.request.getParameter("request");
        }
        if (action.verbose) {
            Fuseki.requestLog.info(String.format("[%d] Form update = \n%s", action.id, requestStr));
        }
        byte[] b = StrUtils.asUTF8bytes((String)requestStr);
        ByteArrayInputStream input = new ByteArrayInputStream(b);
        requestStr = null;
        this.execute(action, input);
        SPARQL_Update.successPage(action, "Update succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(HttpAction action, InputStream input) {
        block17: {
            UsingList usingList = this.processProtocol(action.request);
            UpdateRequest req = null;
            if (!action.isTransactional()) {
                try {
                    req = UpdateFactory.read((UsingList)usingList, (InputStream)input, (String)UpdateParseBase, (Syntax)Syntax.syntaxARQ);
                }
                catch (UpdateException ex) {
                    SPARQL_Update.errorBadRequest(ex.getMessage());
                    return;
                }
                catch (QueryParseException ex) {
                    SPARQL_Update.errorBadRequest(SPARQL_Update.messageForQPE(ex));
                    return;
                }
            }
            action.beginWrite();
            try {
                if (req == null) {
                    UpdateAction.parseExecute((UsingList)usingList, (DatasetGraph)action.getActiveDSG(), (InputStream)input, (String)UpdateParseBase, (Syntax)Syntax.syntaxARQ);
                } else {
                    UpdateAction.execute((UpdateRequest)req, (DatasetGraph)action.getActiveDSG());
                }
                action.commit();
            }
            catch (UpdateException ex) {
                action.abort();
                SPARQL_Update.incCounter(action.srvRef, CounterName.UpdateExecErrors);
                SPARQL_Update.errorOccurred(ex.getMessage());
            }
            catch (QueryParseException ex) {
                action.abort();
                SPARQL_Update.errorBadRequest(SPARQL_Update.messageForQPE(ex));
            }
            catch (Throwable ex) {
                if (ex instanceof ActionErrorException) break block17;
                try {
                    action.abort();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                SPARQL_Update.errorOccurred(ex.getMessage(), ex);
            }
            finally {
                action.endWrite();
            }
        }
    }

    private UsingList processProtocol(HttpServletRequest request) {
        UsingList toReturn = new UsingList();
        String[] usingArgs = request.getParameterValues("using-graph-uri");
        String[] usingNamedArgs = request.getParameterValues("using-named-graph-uri");
        if (usingArgs == null && usingNamedArgs == null) {
            return toReturn;
        }
        if (usingArgs == null) {
            usingArgs = new String[]{};
        }
        if (usingNamedArgs == null) {
            usingNamedArgs = new String[]{};
        }
        for (String nodeUri : usingArgs) {
            toReturn.addUsing(SPARQL_Update.createNode(nodeUri));
        }
        for (String nodeUri : usingNamedArgs) {
            toReturn.addUsingNamed(SPARQL_Update.createNode(nodeUri));
        }
        return toReturn;
    }

    private static Node createNode(String x) {
        try {
            IRI iri = resolver.resolve(x);
            return NodeFactory.createURI((String)iri.toString());
        }
        catch (Exception ex) {
            SPARQL_Update.errorBadRequest("SPARQL Update: bad IRI: " + x);
            return null;
        }
    }
}

