/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryCancelledException;
import com.hp.hpl.jena.sparql.util.Context;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.Counters;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.server.DatasetRegistry;
import org.apache.jena.fuseki.server.FusekiConfig;
import org.apache.jena.fuseki.server.ServiceRef;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.HttpServletResponseTracker;
import org.apache.jena.fuseki.servlets.ServletBase;
import org.apache.jena.web.HttpSC;

public abstract class SPARQL_ServletBase
extends ServletBase {
    protected SPARQL_ServletBase() {
    }

    protected void doCommon(HttpServletRequest request, HttpServletResponse response) {
        try {
            long id = this.allocRequestId(request, (HttpServletResponse)response);
            HttpAction action = this.allocHttpAction(id, request, (HttpServletResponse)response);
            this.printRequest(action);
            action.setStartTime();
            response = action.response;
            this.initResponse(request, (HttpServletResponse)response);
            Context cxt = ARQ.getContext();
            try {
                this.execCommonWorker(action);
            }
            catch (QueryCancelledException ex) {
                String message = String.format("The query timed out (restricted to %s ms)", cxt.get(ARQ.queryTimeout));
                this.responseSendError((HttpServletResponse)response, 503, message);
            }
            catch (ActionErrorException ex) {
                if (ex.exception != null) {
                    ex.exception.printStackTrace(System.err);
                }
                if (ex.message != null) {
                    this.responseSendError((HttpServletResponse)response, ex.rc, ex.message);
                } else {
                    this.responseSendError((HttpServletResponse)response, ex.rc);
                }
            }
            catch (RuntimeIOException ex) {
                log.warn(String.format("[%d] Runtime IO Exception (client left?) RC = %d", id, 500));
                this.responseSendError((HttpServletResponse)response, 500, ex.getMessage());
            }
            catch (Throwable ex) {
                log.warn(String.format("[%d] RC = %d : %s", id, 500, ex.getMessage()), ex);
                this.responseSendError((HttpServletResponse)response, 500, ex.getMessage());
            }
            action.setFinishTime();
            this.printResponse(action);
            this.archiveHttpAction(action);
        }
        catch (Throwable th) {
            log.error("Internal error", th);
        }
    }

    protected HttpAction allocHttpAction(long id, HttpServletRequest request, HttpServletResponse response) {
        return new HttpAction(id, request, response, this.verboseLogging);
    }

    protected abstract void validate(HttpAction var1);

    protected abstract void perform(HttpAction var1);

    protected void startRequest(HttpAction action) {
    }

    protected void finishRequest(HttpAction action) {
    }

    private void archiveHttpAction(HttpAction action) {
        action.minimize();
    }

    private void execCommonWorker(HttpAction action) {
        DatasetRef dsRef = null;
        String uri = action.request.getRequestURI();
        String datasetUri = this.mapRequestToDataset(uri);
        if (datasetUri != null) {
            dsRef = (DatasetRef)DatasetRegistry.get().get(datasetUri);
            if (dsRef == null) {
                SPARQL_ServletBase.errorNotFound("No dataset for URI: " + datasetUri);
                return;
            }
        } else {
            dsRef = FusekiConfig.serviceOnlyDatasetRef();
        }
        action.setDataset(dsRef);
        String serviceName = this.mapRequestToService(dsRef, uri, datasetUri);
        ServiceRef srvRef = dsRef.getServiceRef(serviceName);
        action.setService(srvRef);
        this.executeAction(action);
    }

    protected void inc(AtomicLong x) {
        x.incrementAndGet();
    }

    protected void executeAction(HttpAction action) {
        this.executeLifecycle(action);
    }

    protected void executeLifecycle(HttpAction action) {
        SPARQL_ServletBase.incCounter(action.dsRef, CounterName.Requests);
        SPARQL_ServletBase.incCounter(action.srvRef, CounterName.Requests);
        this.startRequest(action);
        try {
            this.validate(action);
        }
        catch (ActionErrorException ex) {
            SPARQL_ServletBase.incCounter(action.dsRef, CounterName.RequestsBad);
            throw ex;
        }
        try {
            this.perform(action);
            SPARQL_ServletBase.incCounter(action.srvRef, CounterName.RequestsGood);
            SPARQL_ServletBase.incCounter(action.dsRef, CounterName.RequestsGood);
        }
        catch (ActionErrorException ex) {
            SPARQL_ServletBase.incCounter(action.srvRef, CounterName.RequestsBad);
            SPARQL_ServletBase.incCounter(action.dsRef, CounterName.RequestsBad);
            throw ex;
        }
        catch (QueryCancelledException ex) {
            SPARQL_ServletBase.incCounter(action.srvRef, CounterName.RequestsBad);
            SPARQL_ServletBase.incCounter(action.dsRef, CounterName.RequestsBad);
            throw ex;
        }
        finally {
            this.finishRequest(action);
        }
    }

    protected static void incCounter(Counters counters, CounterName name) {
        try {
            if (counters.getCounters().contains(name)) {
                counters.getCounters().inc(name);
            }
        }
        catch (Exception ex) {
            Fuseki.serverLog.warn("Exception on counter inc", (Throwable)ex);
        }
    }

    protected static void decCounter(Counters counters, CounterName name) {
        try {
            if (counters.getCounters().contains(name)) {
                counters.getCounters().dec(name);
            }
        }
        catch (Exception ex) {
            Fuseki.serverLog.warn("Exception on counter dec", (Throwable)ex);
        }
    }

    protected void doPatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(405, "HTTP PATCH not supported");
    }

    private void printRequest(HttpAction action) {
        String url = SPARQL_ServletBase.wholeRequestURL(action.request);
        String method = action.request.getMethod();
        log.info(String.format("[%d] %s %s", action.id, method, url));
        if (action.verbose) {
            Enumeration en = action.request.getHeaderNames();
            while (en.hasMoreElements()) {
                String h = (String)en.nextElement();
                Enumeration vals = action.request.getHeaders(h);
                if (!vals.hasMoreElements()) {
                    log.info(String.format("[%d]   ", action.id, h));
                    continue;
                }
                while (vals.hasMoreElements()) {
                    log.info(String.format("[%d]   %-20s %s", action.id, h, vals.nextElement()));
                }
            }
        }
    }

    private void initResponse(HttpServletRequest request, HttpServletResponse response) {
        SPARQL_ServletBase.setCommonHeaders(response);
        String method = request.getMethod();
        if ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method)) {
            SPARQL_ServletBase.setVaryHeader(response);
        }
    }

    private void printResponse(HttpAction action) {
        long time = action.getTime();
        HttpServletResponseTracker response = action.response;
        if (action.verbose) {
            if (action.contentType != null) {
                log.info(String.format("[%d]   %-20s %s", action.id, "Content-Type", action.contentType));
            }
            if (action.contentLength != -1) {
                log.info(String.format("[%d]   %-20s %d", action.id, "Content-Length", action.contentLength));
            }
            for (Map.Entry<String, String> e : action.headers.entrySet()) {
                log.info(String.format("[%d]   %-20s %s", action.id, e.getKey(), e.getValue()));
            }
        }
        String timeStr = SPARQL_ServletBase.fmtMillis(time);
        if (action.message == null) {
            log.info(String.format("[%d] %d %s (%s) ", action.id, action.statusCode, HttpSC.getMessage((int)action.statusCode), timeStr));
        } else {
            log.info(String.format("[%d] %d %s (%s) ", action.id, action.statusCode, action.message, timeStr));
        }
    }

    private static String fmtMillis(long time) {
        if (time < 1000L) {
            return String.format("%,d ms", time);
        }
        return String.format("%,.3f s", (double)time / 1000.0);
    }

    protected String mapRequestToDataset(String uri) {
        return SPARQL_ServletBase.mapRequestToDataset$(uri);
    }

    protected static String mapRequestToDataset$(String uri) {
        int i = uri.lastIndexOf(47);
        if (i == -1) {
            return null;
        }
        if (i == 0) {
            return uri;
        }
        return uri.substring(0, i);
    }

    protected String mapRequestToService(DatasetRef dsRef, String uri, String datasetURI) {
        if (dsRef == null) {
            return "";
        }
        if (dsRef.name.length() >= uri.length()) {
            return "";
        }
        return uri.substring(dsRef.name.length() + 1);
    }

    protected static String mapRequestToDatasetLongest$(String uri) {
        if (uri == null) {
            return null;
        }
        String ds = null;
        for (String ds2 : DatasetRegistry.get().keys()) {
            if (!uri.startsWith(ds2)) continue;
            if (ds == null) {
                ds = ds2;
                continue;
            }
            if (ds.length() >= ds2.length()) continue;
            ds = ds2;
        }
        return ds;
    }
}

