/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryCancelledException;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ResponseModel;
import org.apache.jena.fuseki.servlets.ResponseResultSet;
import org.apache.jena.fuseki.servlets.SPARQL_Protocol;
import org.apache.jena.riot.web.HttpOp;

public abstract class SPARQL_Query
extends SPARQL_Protocol {
    protected static List<String> allParams = Arrays.asList("query", "default-graph-uri", "named-graph-uri", "query-ref", "stylesheet", "accept", "output", "format", "callback", "force-accept", "timeout");

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        SPARQL_Query.setCommonHeadersForOptions(response);
        response.setHeader("Allow", "GET,OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    @Override
    protected final void perform(HttpAction action) {
        if (action.request.getMethod().equals("GET")) {
            this.executeWithParameter(action);
            return;
        }
        ContentType ct = FusekiLib.getContentType(action);
        if (ct == null) {
            this.executeWithParameter(action);
            return;
        }
        String incoming = ct.getContentType();
        if ("application/sparql-query".equals(incoming)) {
            this.executeBody(action);
            return;
        }
        if ("application/x-www-form-urlencoded".equals(incoming)) {
            this.executeWithParameter(action);
            return;
        }
        SPARQL_Query.error(415, "Bad content type: " + incoming);
    }

    @Override
    protected void validate(HttpAction action) {
        String method = action.request.getMethod().toUpperCase(Locale.ROOT);
        if (!"POST".equals(method) && !"GET".equals(method)) {
            SPARQL_Query.errorMethodNotAllowed("Not a GET or POST request");
        }
        if ("GET".equals(method) && action.request.getQueryString() == null) {
            SPARQL_Query.warning("Service Description / SPARQL Query / " + action.request.getRequestURI());
            SPARQL_Query.errorNotFound("Service Description: " + action.request.getRequestURI());
        }
        this.validateParams(action.request, allParams);
        this.validateRequest(action);
    }

    protected abstract void validateRequest(HttpAction var1);

    protected void validateParams(HttpServletRequest request, Collection<String> params) {
        ContentType ct = FusekiLib.getContentType(request);
        boolean mustHaveQueryParam = true;
        if (ct != null) {
            String incoming = ct.getContentType();
            if ("application/sparql-query".equals(incoming)) {
                mustHaveQueryParam = false;
            } else if (!"application/x-www-form-urlencoded".equals(incoming)) {
                SPARQL_Query.error(415, "Unsupported: " + incoming);
            }
        }
        if (mustHaveQueryParam) {
            String queryStr;
            int N = SPARQL_Query.countParamOccurences(request, "query");
            if (N == 0) {
                SPARQL_Query.errorBadRequest("SPARQL Query: No 'query=' parameter");
            }
            if (N > 1) {
                SPARQL_Query.errorBadRequest("SPARQL Query: Multiple 'query=' parameters");
            }
            if ((queryStr = request.getParameter("query")) == null) {
                SPARQL_Query.errorBadRequest("SPARQL Query: No query specified (no 'query=' found)");
            }
            if (queryStr.isEmpty()) {
                SPARQL_Query.errorBadRequest("SPARQL Query: Empty query string");
            }
        }
        if (params != null) {
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                if (params.contains(name)) continue;
                SPARQL_Query.warning("SPARQL Query: Unrecognize request parameter (ignored): " + name);
            }
        }
    }

    private void executeWithParameter(HttpAction action) {
        String queryString = action.request.getParameter("query");
        this.execute(queryString, action);
    }

    private void executeBody(HttpAction action) {
        String queryString = null;
        try {
            ServletInputStream input = action.request.getInputStream();
            queryString = IO.readWholeFileAsUTF8((InputStream)input);
        }
        catch (IOException ex) {
            SPARQL_Query.errorOccurred(ex);
        }
        this.execute(queryString, action);
    }

    private void execute(String queryString, HttpAction action) {
        String queryStringLog = SPARQL_Query.formatForLog(queryString);
        if (action.verbose) {
            log.info(String.format("[%d] Query = \n%s", action.id, queryString));
        } else {
            log.info(String.format("[%d] Query = %s", action.id, queryStringLog));
        }
        Query query = null;
        try {
            query = QueryFactory.create((String)queryString, (String)"http://example/query-base", (Syntax)Syntax.syntaxARQ);
            queryStringLog = this.formatForLog(query);
            this.validateQuery(action, query);
        }
        catch (ActionErrorException ex) {
            SPARQL_Query.incCounter(action.srvRef, CounterName.RequestsBad);
            throw ex;
        }
        catch (QueryParseException ex) {
            SPARQL_Query.incCounter(action.srvRef, CounterName.RequestsBad);
            SPARQL_Query.errorBadRequest("Parse error: \n" + queryString + "\n\r" + SPARQL_Query.messageForQPE(ex));
        }
        catch (RuntimeIOException ex) {
            SPARQL_Query.errorBadRequest("Runtime IO Exception: \n" + queryString + "\n\r" + ex.getMessage());
        }
        catch (QueryException ex) {
            SPARQL_Query.errorBadRequest("Error: \n" + queryString + "\n\r" + ex.getMessage());
        }
        action.beginRead();
        try {
            Dataset dataset = this.decideDataset(action, query, queryStringLog);
            try (QueryExecution qExec = this.createQueryExecution(query, dataset);){
                SPARQLResult result = this.executeQuery(action, qExec, query, queryStringLog);
                this.sendResults(action, result, query.getPrologue());
            }
        }
        catch (QueryCancelledException ex) {
            SPARQL_Query.incCounter(action.srvRef, CounterName.QueryTimeouts);
            throw ex;
        }
        catch (RuntimeIOException ex) {
            SPARQL_Query.incCounter(action.srvRef, CounterName.QueryExecErrors);
            throw ex;
        }
        catch (QueryExecException ex) {
            SPARQL_Query.incCounter(action.srvRef, CounterName.QueryExecErrors);
            throw ex;
        }
        finally {
            action.endRead();
        }
    }

    protected abstract void validateQuery(HttpAction var1, Query var2);

    protected QueryExecution createQueryExecution(Query query, Dataset dataset) {
        return QueryExecutionFactory.create((Query)query, (Dataset)dataset);
    }

    protected SPARQLResult executeQuery(HttpAction action, QueryExecution qExec, Query query, String queryStringLog) {
        this.setAnyTimeouts(qExec, action);
        if (query.isSelectType()) {
            ResultSet rs = qExec.execSelect();
            rs.hasNext();
            log.info(String.format("[%d] exec/select", action.id));
            return new SPARQLResult(rs);
        }
        if (query.isConstructType()) {
            Model model = qExec.execConstruct();
            log.info(String.format("[%d] exec/construct", action.id));
            return new SPARQLResult(model);
        }
        if (query.isDescribeType()) {
            Model model = qExec.execDescribe();
            log.info(String.format("[%d] exec/describe", action.id));
            return new SPARQLResult(model);
        }
        if (query.isAskType()) {
            boolean b = qExec.execAsk();
            log.info(String.format("[%d] exec/ask", action.id));
            return new SPARQLResult(b);
        }
        SPARQL_Query.errorBadRequest("Unknown query type - " + queryStringLog);
        return null;
    }

    private void setAnyTimeouts(QueryExecution qexec, HttpAction action) {
        if (!action.getDatasetRef().allowTimeoutOverride) {
            return;
        }
        long desiredTimeout = Long.MAX_VALUE;
        String timeoutHeader = action.request.getHeader("Timeout");
        String timeoutParameter = action.request.getParameter("timeout");
        if (timeoutHeader != null) {
            try {
                desiredTimeout = (int)Float.parseFloat(timeoutHeader) * 1000;
            }
            catch (NumberFormatException e) {
                throw new FusekiException("Timeout header must be a number", e);
            }
        }
        if (timeoutParameter != null) {
            try {
                desiredTimeout = (int)Float.parseFloat(timeoutParameter) * 1000;
            }
            catch (NumberFormatException e) {
                throw new FusekiException("timeout parameter must be a number", e);
            }
        }
        desiredTimeout = Math.min(action.getDatasetRef().maximumTimeoutOverride, desiredTimeout);
        if (desiredTimeout != Long.MAX_VALUE) {
            qexec.setTimeout(desiredTimeout);
        }
    }

    protected abstract Dataset decideDataset(HttpAction var1, Query var2, String var3);

    protected void sendResults(HttpAction action, SPARQLResult result, Prologue qPrologue) {
        if (result.isResultSet()) {
            ResponseResultSet.doResponseResultSet(action, result.getResultSet(), qPrologue);
        } else if (result.isGraph()) {
            ResponseModel.doResponseModel(action, result.getModel());
        } else if (result.isBoolean()) {
            ResponseResultSet.doResponseResultSet(action, result.getBooleanResult());
        } else {
            SPARQL_Query.errorOccurred("Unknown or invalid result type");
        }
    }

    private String formatForLog(Query query) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        out.setFlatMode(true);
        query.serialize(out);
        return out.asString();
    }

    private String getRemoteString(String queryURI) {
        return HttpOp.execHttpGetString((String)queryURI);
    }
}

