/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.fuseki.server.Counter;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.DatasetRef;
import org.apache.jena.fuseki.server.DatasetRegistry;
import org.apache.jena.fuseki.server.ServiceRef;

public class StatsServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.statsJSON(req, resp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void statsJSON(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServletOutputStream out = resp.getOutputStream();
        resp.setContentType("application/json");
        resp.setCharacterEncoding("utf-8");
        JsonObject obj = new JsonObject();
        JsonObject datasets = new JsonObject();
        JsonObject server = new JsonObject();
        server.put("host", req.getLocalName() + ":" + req.getLocalPort());
        for (String ds : DatasetRegistry.get().keys()) {
            this.statsJSON(datasets, ds);
        }
        obj.put("server", (JsonValue)server);
        obj.put("datasets", (JsonValue)datasets);
        JSON.write((OutputStream)out, (JsonValue)obj);
        out.flush();
    }

    private void statsJSON(JsonObject datasets, String ds) {
        DatasetRef desc = (DatasetRef)DatasetRegistry.get().get(ds);
        JsonObject stats = new JsonObject();
        datasets.put(ds, (JsonValue)stats);
        stats.put(CounterName.Requests.name(), desc.getCounters().value(CounterName.Requests));
        stats.put(CounterName.RequestsGood.name(), desc.getCounters().value(CounterName.RequestsGood));
        stats.put(CounterName.RequestsBad.name(), desc.getCounters().value(CounterName.RequestsBad));
        JsonObject services = new JsonObject();
        for (ServiceRef srvRef : desc.getServiceRefs()) {
            JsonObject epStats = new JsonObject();
            this.statsJSON(epStats, srvRef);
            services.put(srvRef.name, (JsonValue)epStats);
            JsonArray endpoints = new JsonArray();
            epStats.put("endpoints", (JsonValue)endpoints);
            for (String ep : srvRef.endpoints) {
                endpoints.add(ep);
            }
        }
        stats.put("services", (JsonValue)services);
    }

    private void statsJSON(JsonObject epStats, ServiceRef srvRef) {
        for (CounterName cn : srvRef.getCounters().counters()) {
            Counter c = srvRef.getCounters().get(cn);
            epStats.put(cn.name(), c.value());
        }
    }

    private void statsTxt(HttpServletResponse resp) throws IOException {
        ServletOutputStream out = resp.getOutputStream();
        resp.setContentType("text/plain");
        resp.setCharacterEncoding("utf-8");
        Iterator<String> iter = DatasetRegistry.get().keys().iterator();
        while (iter.hasNext()) {
            String ds = iter.next();
            DatasetRef desc = (DatasetRef)DatasetRegistry.get().get(ds);
            this.statsTxt(out, desc);
            if (!iter.hasNext()) continue;
            out.println();
        }
        out.flush();
    }

    private void statsTxt(ServletOutputStream out, DatasetRef desc) throws IOException {
        out.println("Dataset: " + desc.name);
        out.println("    Requests      = " + desc.getCounters().value(CounterName.Requests));
        out.println("    Good          = " + desc.getCounters().value(CounterName.RequestsGood));
        out.println("    Bad           = " + desc.getCounters().value(CounterName.RequestsBad));
        out.println("  SPARQL Query:");
        out.println("    Request       = " + desc.query.getCounters().value(CounterName.Requests));
        out.println("    Good          = " + desc.query.getCounters().value(CounterName.RequestsGood));
        out.println("    Bad requests  = " + desc.query.getCounters().value(CounterName.RequestsBad));
        out.println("    Timeouts      = " + desc.query.getCounters().value(CounterName.QueryTimeouts));
        out.println("    Bad exec      = " + desc.query.getCounters().value(CounterName.QueryExecErrors));
        out.println("  SPARQL Update:");
        out.println("    Request       = " + desc.update.getCounters().value(CounterName.Requests));
        out.println("    Good          = " + desc.update.getCounters().value(CounterName.RequestsGood));
        out.println("    Bad requests  = " + desc.update.getCounters().value(CounterName.RequestsBad));
        out.println("    Bad exec      = " + desc.update.getCounters().value(CounterName.UpdateExecErrors));
        out.println("  Upload:");
        out.println("    Requests      = " + desc.upload.getCounters().value(CounterName.Requests));
        out.println("    Good          = " + desc.upload.getCounters().value(CounterName.RequestsGood));
        out.println("    Bad           = " + desc.upload.getCounters().value(CounterName.RequestsBad));
        out.println("  SPARQL Graph Store Protocol:");
        out.println("    GETs          = " + this.gspValue(desc, CounterName.GSPget) + " (good=" + this.gspValue(desc, CounterName.GSPgetGood) + "/bad=" + this.gspValue(desc, CounterName.GSPgetBad) + ")");
        out.println("    PUTs          = " + this.gspValue(desc, CounterName.GSPput) + " (good=" + this.gspValue(desc, CounterName.GSPputGood) + "/bad=" + this.gspValue(desc, CounterName.GSPputBad) + ")");
        out.println("    POSTs         = " + this.gspValue(desc, CounterName.GSPpost) + " (good=" + this.gspValue(desc, CounterName.GSPpostGood) + "/bad=" + this.gspValue(desc, CounterName.GSPpostBad) + ")");
        out.println("    DELETEs       = " + this.gspValue(desc, CounterName.GSPdelete) + " (good=" + this.gspValue(desc, CounterName.GSPdeleteGood) + "/bad=" + this.gspValue(desc, CounterName.GSPdeleteBad) + ")");
        out.println("    HEADs         = " + this.gspValue(desc, CounterName.GSPhead) + " (good=" + this.gspValue(desc, CounterName.GSPheadGood) + "/bad=" + this.gspValue(desc, CounterName.GSPheadBad) + ")");
    }

    private long gspValue(DatasetRef desc, CounterName cn) {
        long x1 = desc.readGraphStore.getCounters().value(cn);
        long x2 = desc.readWriteGraphStore.getCounters().value(cn);
        return x1 + x2;
    }
}

