/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.tdb.TDBFactory;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.fuseki.server.FusekiConfig;
import org.apache.jena.fuseki.server.SPARQLServer;
import org.apache.jena.fuseki.server.ServerConfig;

public class EmbeddedFusekiServer {
    private SPARQLServer server = null;

    public static EmbeddedFusekiServer mem(int port, String datasetPath) {
        DatasetGraph dsg = DatasetGraphFactory.createMem();
        return EmbeddedFusekiServer.create(port, dsg, datasetPath);
    }

    public static EmbeddedFusekiServer memTDB(int port, String datasetPath) {
        DatasetGraph dsg = TDBFactory.createDatasetGraph();
        return EmbeddedFusekiServer.create(port, dsg, datasetPath);
    }

    public static EmbeddedFusekiServer create(int port, DatasetGraph dsg, String datasetPath) {
        ServerConfig conf = FusekiConfig.defaultConfiguration(datasetPath, dsg, true, true);
        conf.port = port;
        conf.pagesPort = port;
        if (!FileOps.exists((String)conf.pages)) {
            conf.pages = null;
        }
        return new EmbeddedFusekiServer(conf);
    }

    public static EmbeddedFusekiServer configure(int port, String fileConfig) {
        ServerConfig conf = FusekiConfig.configure(fileConfig);
        conf.port = port;
        conf.pagesPort = port;
        if (!FileOps.exists((String)conf.pages)) {
            conf.pages = null;
        }
        return new EmbeddedFusekiServer(conf);
    }

    public EmbeddedFusekiServer(ServerConfig conf) {
        this.server = new SPARQLServer(conf);
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        this.server.stop();
    }
}

