/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.http;

import com.hp.hpl.jena.sparql.engine.http.Params;
import com.hp.hpl.jena.util.FileUtils;
import java.io.Closeable;
import java.io.IOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.fuseki.ServerTest;
import org.apache.jena.riot.system.IRILib;
import org.apache.jena.riot.web.HttpOp;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHttpOp
extends BaseTest {
    static String pingURL = "http://localhost:3635/ping.txt";
    static String graphURL = "http://localhost:3635/dataset/data?default";
    static String queryURL = "http://localhost:3635/dataset/query";
    static String updateURL = "http://localhost:3635/dataset/update";
    static String simpleQuery = queryURL + "?query=" + IRILib.encodeUriComponent((String)"ASK{}");
    static String graphString = "@prefix : <http://example/> . :s :p :o .";

    @BeforeClass
    public static void beforeClass() {
        ServerTest.allocServer();
    }

    @AfterClass
    public static void afterClass() {
        ServerTest.freeServer();
    }

    @Test
    public void httpGet_01() {
        TypedInputStream in = HttpOp.execHttpGet((String)pingURL);
        IO.close((Closeable)in);
    }

    @Test(expected=HttpException.class)
    public void httpGet_02() {
        try {
            TypedInputStream in = HttpOp.execHttpGet((String)"http://localhost:3635/does-not-exist");
            IO.close((Closeable)in);
        }
        catch (HttpException ex) {
            TestHttpOp.assertEquals((long)404L, (long)ex.getResponseCode());
            throw ex;
        }
    }

    @Test
    public void httpGet_03() throws IOException {
        String x = HttpOp.execHttpGetString((String)pingURL);
        String y = FileUtils.readWholeFileAsUTF8((String)"pages/ping.txt");
        TestHttpOp.assertEquals((Object)y, (Object)x);
    }

    @Test
    public void httpGet_04() {
        String x = HttpOp.execHttpGetString((String)"http://localhost:3635/does-not-exist");
        TestHttpOp.assertNull((Object)x);
    }

    @Test
    public void httpGet_05() {
        TypedInputStream in = HttpOp.execHttpGet((String)simpleQuery);
        IO.close((Closeable)in);
    }

    @Test
    public void queryGet_01() {
        TypedInputStream in = HttpOp.execHttpGet((String)simpleQuery);
        IO.close((Closeable)in);
    }

    @Test(expected=HttpException.class)
    public void queryGet_02() {
        try {
            TypedInputStream in = HttpOp.execHttpGet((String)(queryURL + "?query="));
            IO.close((Closeable)in);
        }
        catch (HttpException ex) {
            TestHttpOp.assertEquals((long)ex.getResponseCode(), (long)400L);
            throw ex;
        }
    }

    @Test(expected=HttpException.class)
    public void httpPost_01() {
        try {
            HttpOp.execHttpPost((String)queryURL, (String)"ASK{}", (String)"text/plain");
        }
        catch (HttpException ex) {
            TestHttpOp.assertEquals((long)ex.getResponseCode(), (long)415L);
            throw ex;
        }
    }

    @Test(expected=HttpException.class)
    public void httpPost_02() {
        try {
            HttpOp.execHttpPost((String)queryURL, (String)"ASK{}", (String)"application/sparql-query");
        }
        catch (HttpException ex) {
            TestHttpOp.assertEquals((long)ex.getResponseCode(), (long)415L);
            throw ex;
        }
    }

    @Test(expected=HttpException.class)
    public void httpPost_03() {
        try {
            HttpOp.execHttpPost((String)queryURL, (String)"ASK{}", (String)"application/octet-stream");
        }
        catch (HttpException ex) {
            TestHttpOp.assertEquals((long)ex.getResponseCode(), (long)415L);
            throw ex;
        }
    }

    @Test
    public void httpPost_04() {
        Params params = new Params();
        params.addParam("query", "ASK{}");
        TypedInputStream in = HttpOp.execHttpPostFormStream((String)queryURL, (Params)params, (String)"application/sparql-results+json");
        IO.close((Closeable)in);
    }

    @Test(expected=HttpException.class)
    public void httpPost_05() {
        Params params = new Params();
        params.addParam("query", "ASK{}");
        TypedInputStream in = null;
        try {
            in = HttpOp.execHttpPostFormStream((String)updateURL, (Params)params, (String)"application/sparql-results+json");
        }
        catch (HttpException ex) {
            try {
                TestHttpOp.assertEquals((long)ex.getResponseCode(), (long)400L);
                throw ex;
            }
            catch (Throwable throwable) {
                IO.close(in);
                throw throwable;
            }
        }
        IO.close((Closeable)in);
    }

    @Test
    public void httpPost_06() {
        Params params = new Params();
        params.addParam("request", "CLEAR ALL");
        HttpOp.execHttpPostForm((String)updateURL, (Params)params);
    }

    @Test
    public void gsp_01() {
        String x = HttpOp.execHttpGetString((String)graphURL, (String)"application/rdf+xml");
        TestHttpOp.assertTrue((boolean)x.contains("</"));
        TestHttpOp.assertTrue((boolean)x.contains(":RDF"));
    }

    @Test
    public void gsp_02() {
        String x = HttpOp.execHttpGetString((String)graphURL, (String)"application/n-triples");
        TestHttpOp.assertTrue((boolean)x.isEmpty());
    }

    @Test
    public void gsp_03() {
        HttpOp.execHttpPut((String)graphURL, (String)"text/turtle", (String)graphString);
    }

    @Test
    public void gsp_04() {
        HttpOp.execHttpPut((String)graphURL, (String)"text/turtle", (String)graphString);
        String s1 = HttpOp.execHttpGetString((String)graphURL, (String)"application/n-triples");
        TestHttpOp.assertFalse((boolean)s1.isEmpty());
        HttpOp.execHttpDelete((String)graphURL);
        String s2 = HttpOp.execHttpGetString((String)graphURL, (String)"application/n-triples");
        TestHttpOp.assertTrue((boolean)s2.isEmpty());
    }

    @Test
    public void gsp_05() {
        HttpOp.execHttpDelete((String)graphURL);
        HttpOp.execHttpPost((String)graphURL, (String)"text/turtle", (String)graphString);
        String s1 = HttpOp.execHttpGetString((String)graphURL, (String)"application/n-triples");
        TestHttpOp.assertFalse((boolean)s1.isEmpty());
        HttpOp.execHttpDelete((String)graphURL);
        String s2 = HttpOp.execHttpGetString((String)graphURL, (String)"application/n-triples");
        TestHttpOp.assertTrue((boolean)s2.isEmpty());
    }
}

