/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.http;

import com.hp.hpl.jena.query.DatasetAccessor;
import com.hp.hpl.jena.query.DatasetAccessorFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.fuseki.ServerTest;
import org.apache.jena.riot.web.HttpOp;
import org.apache.jena.web.HttpSC;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDatasetAccessorHTTP
extends BaseTest {
    static final String datasetURI_not_1 = "http://localhost:3635/junk";
    static final String datasetURI_not_2 = "http://localhost:3635/dataset/data/not";
    static final String datasetURI_not_3 = "http://localhost:3635/dataset/not/data";

    @BeforeClass
    public static void beforeClass() {
        ServerTest.allocServer();
    }

    @AfterClass
    public static void afterClass() {
        ServerTest.freeServer();
    }

    @Before
    public void before() {
        ServerTest.resetServer();
    }

    @Test(expected=HttpException.class)
    public void test_ds_1() {
        try {
            HttpOp.execHttpGet((String)"http://localhost:3635/dataset/data");
        }
        catch (HttpException ex) {
            TestDatasetAccessorHTTP.assertTrue((boolean)HttpSC.isClientError((int)ex.getResponseCode()));
            throw ex;
        }
    }

    @Test(expected=HttpException.class)
    public void test_ds_2() {
        try {
            HttpOp.execHttpGet((String)datasetURI_not_1);
        }
        catch (HttpException ex) {
            TestDatasetAccessorHTTP.assertEquals((long)404L, (long)ex.getResponseCode());
            throw ex;
        }
    }

    @Test(expected=HttpException.class)
    public void test_ds_3() {
        try {
            HttpOp.execHttpGet((String)datasetURI_not_2);
        }
        catch (HttpException ex) {
            TestDatasetAccessorHTTP.assertEquals((long)404L, (long)ex.getResponseCode());
            throw ex;
        }
    }

    @Test
    public void test_404_1() {
        DatasetAccessor du = DatasetAccessorFactory.createHTTP((String)datasetURI_not_1);
        Model graph = du.getModel("http://graph/99");
        TestDatasetAccessorHTTP.assertNull((Object)graph);
    }

    @Test
    public void test_404_2() {
        DatasetAccessor du = DatasetAccessorFactory.createHTTP((String)datasetURI_not_2);
        Model graph = du.getModel("http://graph/99");
        TestDatasetAccessorHTTP.assertNull((Object)graph);
    }

    @Test
    public void test_404_3() {
        DatasetAccessor du = DatasetAccessorFactory.createHTTP((String)"http://localhost:3635/dataset/data");
        Model graph = du.getModel("http://graph/99");
        TestDatasetAccessorHTTP.assertNull((Object)graph);
    }

    @Test
    public void head_01() {
        DatasetAccessor du = TestDatasetAccessorHTTP.create();
        boolean b = du.containsModel("http://graph/1");
        TestDatasetAccessorHTTP.assertFalse((String)"Blank remote dataset as a named graph", (boolean)b);
    }

    @Test
    public void head_02() {
        DatasetAccessor du = TestDatasetAccessorHTTP.create();
        du.putModel("http://graph/1", ServerTest.model1);
        boolean exists = du.containsModel("http://graph/1");
        TestDatasetAccessorHTTP.assertTrue((boolean)exists);
        exists = du.containsModel("http://graph/2");
        TestDatasetAccessorHTTP.assertFalse((String)"Expected gn2 not to exist (1)", (boolean)exists);
        exists = du.containsModel("http://graph/2");
        TestDatasetAccessorHTTP.assertFalse((String)"Expected gn2 not to exist (2)", (boolean)exists);
        du.deleteModel("http://graph/1");
    }

    @Test
    public void get_01() {
        DatasetAccessor du = TestDatasetAccessorHTTP.create();
        Model graph = du.getModel();
        TestDatasetAccessorHTTP.assertTrue((boolean)graph.isEmpty());
    }

    @Test
    public void get_02() {
        DatasetAccessor du = TestDatasetAccessorHTTP.create();
        Model graph = du.getModel("http://graph/1");
        TestDatasetAccessorHTTP.assertNull((Object)graph);
    }

    @Test
    public void delete_01() {
        DatasetAccessor du = TestDatasetAccessorHTTP.create();
        du.deleteDefault();
    }

    @Test
    public void delete_02() {
        DatasetAccessor du = TestDatasetAccessorHTTP.create();
        du.deleteModel("http://graph/1");
        boolean exists = du.containsModel("http://graph/1");
        TestDatasetAccessorHTTP.assertFalse((String)"Expected gn1 not to exist", (boolean)exists);
    }

    @Test
    public void put_01() {
        DatasetAccessor du = TestDatasetAccessorHTTP.create();
        du.putModel(ServerTest.model1);
        Model graph = du.getModel();
        TestDatasetAccessorHTTP.assertTrue((boolean)graph.isIsomorphicWith(ServerTest.model1));
        du.deleteDefault();
        graph = du.getModel();
        TestDatasetAccessorHTTP.assertTrue((boolean)graph.isEmpty());
    }

    @Test
    public void put_02() {
        DatasetAccessor du = TestDatasetAccessorHTTP.create();
        du.putModel("http://graph/1", ServerTest.model1);
        boolean exists = du.containsModel("http://graph/1");
        TestDatasetAccessorHTTP.assertTrue((boolean)exists);
        exists = du.containsModel("http://graph/2");
        TestDatasetAccessorHTTP.assertFalse((String)"Expected gn2 not to exist", (boolean)exists);
        Model graph = du.getModel();
        TestDatasetAccessorHTTP.assertTrue((boolean)graph.isEmpty());
        graph = du.getModel("http://graph/1");
        TestDatasetAccessorHTTP.assertTrue((boolean)graph.isIsomorphicWith(ServerTest.model1));
        du.deleteModel("http://graph/1");
        exists = du.containsModel("http://graph/1");
        TestDatasetAccessorHTTP.assertFalse((String)"Expected gn1 not to exist", (boolean)exists);
        graph = du.getModel("http://graph/1");
        TestDatasetAccessorHTTP.assertNull((Object)graph);
    }

    @Test
    public void put_03() {
        DatasetAccessor du = TestDatasetAccessorHTTP.create();
        du.putModel(ServerTest.model1);
        du.putModel(ServerTest.model2);
        Model graph = du.getModel();
        TestDatasetAccessorHTTP.assertFalse((boolean)graph.isIsomorphicWith(ServerTest.model1));
        TestDatasetAccessorHTTP.assertTrue((boolean)graph.isIsomorphicWith(ServerTest.model2));
        du.deleteDefault();
        graph = du.getModel();
        TestDatasetAccessorHTTP.assertTrue((boolean)graph.isEmpty());
    }

    @Test
    public void post_01() {
        DatasetAccessor du = TestDatasetAccessorHTTP.create();
        du.putModel(ServerTest.model1);
        du.add(ServerTest.model2);
        Model graph = du.getModel();
        Model graph3 = ModelFactory.createDefaultModel();
        graph3.add(ServerTest.model1);
        graph3.add(ServerTest.model2);
        TestDatasetAccessorHTTP.assertFalse((boolean)graph.isIsomorphicWith(ServerTest.model1));
        TestDatasetAccessorHTTP.assertFalse((boolean)graph.isIsomorphicWith(ServerTest.model2));
        TestDatasetAccessorHTTP.assertTrue((boolean)graph.isIsomorphicWith(graph3));
        du.deleteDefault();
        graph = du.getModel();
        TestDatasetAccessorHTTP.assertTrue((boolean)graph.isEmpty());
    }

    @Test
    public void post_02() {
        DatasetAccessor du = TestDatasetAccessorHTTP.create();
        du.add(ServerTest.model1);
        du.add(ServerTest.model2);
        Model graph = du.getModel();
        Model graph3 = ModelFactory.createDefaultModel();
        graph3.add(ServerTest.model1);
        graph3.add(ServerTest.model2);
        TestDatasetAccessorHTTP.assertFalse((boolean)graph.isIsomorphicWith(ServerTest.model1));
        TestDatasetAccessorHTTP.assertFalse((boolean)graph.isIsomorphicWith(ServerTest.model2));
        TestDatasetAccessorHTTP.assertTrue((boolean)graph.isIsomorphicWith(graph3));
        du.deleteDefault();
        graph = du.getModel();
        TestDatasetAccessorHTTP.assertTrue((boolean)graph.isEmpty());
    }

    @Test
    public void clearup_1() {
        DatasetAccessor du = TestDatasetAccessorHTTP.create();
        du.deleteDefault();
        du.deleteModel("http://graph/1");
        du.deleteModel("http://graph/2");
        du.deleteModel("http://graph/99");
    }

    static DatasetAccessor create() {
        return DatasetAccessorFactory.createHTTP((String)"http://localhost:3635/dataset/data");
    }
}

