/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import com.hp.hpl.jena.query.DatasetAccessor;
import com.hp.hpl.jena.query.DatasetAccessorFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import com.hp.hpl.jena.sparql.util.Convert;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.fuseki.ServerTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSPARQLProtocol
extends BaseTest {
    @BeforeClass
    public static void beforeClass() {
        ServerTest.allocServer();
        ServerTest.resetServer();
        DatasetAccessor du = DatasetAccessorFactory.createHTTP((String)"http://localhost:3635/dataset/data");
        du.putModel(ServerTest.model1);
        du.putModel("http://graph/1", ServerTest.model2);
    }

    @AfterClass
    public static void afterClass() {
        ServerTest.resetServer();
        ServerTest.freeServer();
    }

    static String query(String base, String queryString) {
        return base + "?query=" + Convert.encWWWForm((String)queryString);
    }

    @Test
    public void query_01() {
        Query query = QueryFactory.create((String)"SELECT * { ?s ?p ?o }");
        QueryExecution qexec = QueryExecutionFactory.sparqlService((String)"http://localhost:3635/dataset/query", (Query)query);
        ResultSet rs = qexec.execSelect();
        int x = ResultSetFormatter.consume((ResultSet)rs);
        TestSPARQLProtocol.assertTrue((x != 0 ? 1 : 0) != 0);
    }

    @Test
    public void query_02() {
        Query query = QueryFactory.create((String)"SELECT * { ?s ?p ?o }");
        QueryEngineHTTP engine = QueryExecutionFactory.createServiceRequest((String)"http://localhost:3635/dataset/query", (Query)query);
        engine.setSelectContentType("application/sparql-results+json");
        ResultSet rs = engine.execSelect();
        int x = ResultSetFormatter.consume((ResultSet)rs);
        TestSPARQLProtocol.assertTrue((x != 0 ? 1 : 0) != 0);
    }

    @Test
    public void update_01() {
        UpdateRequest update = UpdateFactory.create((String)"INSERT DATA {}");
        UpdateProcessor proc = UpdateExecutionFactory.createRemote((UpdateRequest)update, (String)"http://localhost:3635/dataset/update");
        proc.execute();
    }

    @Test
    public void update_02() {
        UpdateRequest update = UpdateFactory.create((String)"INSERT DATA {}");
        UpdateProcessor proc = UpdateExecutionFactory.createRemoteForm((UpdateRequest)update, (String)"http://localhost:3635/dataset/update");
        proc.execute();
    }
}

