/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import com.hp.hpl.jena.query.DatasetAccessor;
import com.hp.hpl.jena.query.DatasetAccessorFactory;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.resultset.ResultSetCompare;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderResultSet;
import com.hp.hpl.jena.sparql.util.Convert;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.fuseki.ServerTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestQuery
extends BaseTest {
    protected static ResultSet rs1 = null;

    @BeforeClass
    public static void beforeClass() {
        ServerTest.allocServer();
        ServerTest.resetServer();
        DatasetAccessor du = DatasetAccessorFactory.createHTTP((String)"http://localhost:3635/dataset/data");
        du.putModel(ServerTest.model1);
        du.putModel("http://graph/1", ServerTest.model2);
    }

    @AfterClass
    public static void afterClass() {
        DatasetAccessor du = DatasetAccessorFactory.createHTTP((String)"http://localhost:3635/dataset/data");
        du.deleteDefault();
        ServerTest.freeServer();
    }

    @Test
    public void query_01() {
        this.execQuery("SELECT * {?s ?p ?o}", 1);
    }

    @Test
    public void query_recursive_01() {
        String query = "SELECT * WHERE { SERVICE <http://localhost:3635/dataset/query> { ?s ?p ?o . BIND(?o AS ?x) } }";
        try (QueryExecution qExec = QueryExecutionFactory.sparqlService((String)"http://localhost:3635/dataset/query", (String)query);){
            ResultSet rs = qExec.execSelect();
            Var x = Var.alloc((String)"x");
            while (rs.hasNext()) {
                Binding b = rs.nextBinding();
                Assert.assertNotNull((Object)b.get(x));
            }
        }
    }

    @Test
    public void query_with_params_01() {
        String query = "ASK { }";
        try (QueryExecution qExec = QueryExecutionFactory.sparqlService((String)"http://localhost:3635/dataset/query?output=json", (String)query);){
            boolean result = qExec.execAsk();
            Assert.assertTrue((boolean)result);
        }
    }

    @Test
    public void request_id_header_01() throws IOException {
        String qs = Convert.encWWWForm((String)"ASK{}");
        URL u = new URL("http://localhost:3635/dataset/query?query=" + qs);
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        Assert.assertTrue((conn.getHeaderField("Fuseki-Request-ID") != null ? 1 : 0) != 0);
    }

    private void execQuery(String queryString, int exceptedRowCount) {
        QueryExecution qExec = QueryExecutionFactory.sparqlService((String)"http://localhost:3635/dataset/query", (String)queryString);
        ResultSet rs = qExec.execSelect();
        int x = ResultSetFormatter.consume((ResultSet)rs);
        TestQuery.assertEquals((long)exceptedRowCount, (long)x);
    }

    private void execQuery(String queryString, ResultSet expectedResultSet) {
        QueryExecution qExec = QueryExecutionFactory.sparqlService((String)"http://localhost:3635/dataset/query", (String)queryString);
        ResultSet rs = qExec.execSelect();
        boolean b = ResultSetCompare.equalsByTerm((ResultSet)rs, (ResultSet)expectedResultSet);
        TestQuery.assertTrue((String)"Result sets different", (boolean)b);
    }

    static {
        Item item = SSE.parseItem((String)"(resultset (?s ?p ?o) (row (?s <x>)(?p <p>)(?o 1)))");
        rs1 = BuilderResultSet.build((Item)item);
    }
}

