/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.DatasetAccessor;
import com.hp.hpl.jena.query.DatasetAccessorFactory;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import com.hp.hpl.jena.sparql.engine.http.QueryExceptionHTTP;
import com.hp.hpl.jena.sparql.engine.http.Service;
import com.hp.hpl.jena.sparql.modify.UpdateProcessRemoteBase;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.logging.Level;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.atlas.web.auth.PreemptiveBasicAuthenticator;
import org.apache.jena.atlas.web.auth.ScopedAuthenticator;
import org.apache.jena.atlas.web.auth.ServiceAuthenticator;
import org.apache.jena.atlas.web.auth.SimpleAuthenticator;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.FusekiConfig;
import org.apache.jena.fuseki.server.SPARQLServer;
import org.apache.jena.fuseki.server.ServerConfig;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAuth {
    public static final int authPort = 3645;
    public static final String authUrlRoot = "http://localhost:3645/";
    public static final String authDatasetPath = "/dataset";
    public static final String authServiceUpdate = "http://localhost:3645/dataset/update";
    public static final String authServiceQuery = "http://localhost:3645/dataset/query";
    public static final String authServiceREST = "http://localhost:3645/dataset/data";
    private static File realmFile;
    private static SPARQLServer server;

    @BeforeClass
    public static void setup() throws IOException {
        realmFile = File.createTempFile("realm", ".properties");
        try (FileWriter writer = new FileWriter(realmFile);){
            writer.write("allowed: password, fuseki\n");
            writer.write("forbidden: password, other");
        }
        LogCtl.logLevel((String)Fuseki.serverLog.getName(), (org.apache.log4j.Level)org.apache.log4j.Level.WARN, (Level)Level.WARNING);
        LogCtl.logLevel((String)Fuseki.requestLog.getName(), (org.apache.log4j.Level)org.apache.log4j.Level.WARN, (Level)Level.WARNING);
        LogCtl.logLevel((String)"org.eclipse.jetty", (org.apache.log4j.Level)org.apache.log4j.Level.WARN, (Level)Level.WARNING);
        DatasetGraph dsg = DatasetGraphFactory.createMem();
        ServerConfig conf = FusekiConfig.defaultConfiguration((String)authDatasetPath, (DatasetGraph)dsg, (boolean)true, (boolean)true);
        conf.port = 3645;
        conf.pagesPort = 3645;
        conf.authConfigFile = realmFile.getAbsolutePath();
        server = new SPARQLServer(conf);
        server.start();
    }

    @AfterClass
    public static void teardown() {
        server.stop();
        realmFile.delete();
    }

    @Test(expected=QueryExceptionHTTP.class)
    public void query_with_auth_01() {
        QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)authServiceQuery, (String)"ASK { }");
        qe.execAsk();
    }

    @Test(expected=QueryExceptionHTTP.class)
    public void query_with_auth_02() {
        QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)authServiceQuery, (String)"ASK { }");
        qe.setBasicAuthentication("allowed", "incorrect".toCharArray());
        qe.execAsk();
    }

    @Test
    public void query_with_auth_03() {
        QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)authServiceQuery, (String)"ASK { }");
        qe.setBasicAuthentication("allowed", "password".toCharArray());
        Assert.assertTrue((boolean)qe.execAsk());
    }

    @Test(expected=QueryExceptionHTTP.class)
    public void query_with_auth_04() {
        QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)authServiceQuery, (String)"ASK { }");
        qe.setBasicAuthentication("forbidden", "password".toCharArray());
        qe.execAsk();
    }

    @Test
    public void query_with_auth_05() {
        QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)authServiceQuery, (String)"ASK { }");
        qe.setAllowDeflate(true);
        qe.setAllowGZip(true);
        qe.setBasicAuthentication("allowed", "password".toCharArray());
        Assert.assertTrue((boolean)qe.execAsk());
    }

    @Test(expected=QueryExceptionHTTP.class)
    public void query_with_auth_06() {
        QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)authServiceQuery, (String)"ASK { }");
        qe.setAllowDeflate(true);
        qe.setAllowGZip(true);
        qe.setBasicAuthentication("allowed", "incorrect".toCharArray());
        qe.execAsk();
    }

    @Test(expected=QueryExceptionHTTP.class)
    public void query_with_auth_07() throws URISyntaxException {
        QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)authServiceQuery, (String)"ASK { }");
        ScopedAuthenticator authenticator = new ScopedAuthenticator(new URI("http://example"), "allowed", "password".toCharArray());
        qe.setAuthenticator((HttpAuthenticator)authenticator);
        qe.execAsk();
    }

    @Test
    public void query_with_auth_08() throws URISyntaxException {
        QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)authServiceQuery, (String)"ASK { }");
        ScopedAuthenticator authenticator = new ScopedAuthenticator(new URI(authServiceQuery), "allowed", "password".toCharArray());
        qe.setAuthenticator((HttpAuthenticator)authenticator);
        Assert.assertTrue((boolean)qe.execAsk());
    }

    @Test
    public void query_with_auth_09() throws URISyntaxException {
        QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)authServiceQuery, (String)"ASK { }");
        ScopedAuthenticator authenticator = new ScopedAuthenticator(new URI(authServiceQuery), "allowed", "password".toCharArray());
        qe.setAuthenticator((HttpAuthenticator)new PreemptiveBasicAuthenticator((HttpAuthenticator)authenticator));
        Assert.assertTrue((boolean)qe.execAsk());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void query_with_auth_10() {
        Context ctx = ARQ.getContext();
        try {
            QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)authServiceQuery, (String)"ASK { }");
            HashMap<String, Context> serviceContext = new HashMap<String, Context>();
            Context authContext = new Context();
            authContext.put(Service.queryAuthUser, (Object)"allowed");
            authContext.put(Service.queryAuthPwd, (Object)"password");
            serviceContext.put(authServiceQuery, authContext);
            ctx.put(Service.serviceContext, serviceContext);
            qe.setAuthenticator((HttpAuthenticator)new ServiceAuthenticator());
            Assert.assertTrue((boolean)qe.execAsk());
        }
        finally {
            ctx.remove(Service.serviceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void query_with_auth_11() {
        Context ctx = ARQ.getContext();
        try {
            QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)authServiceQuery, (String)"ASK { }");
            HashMap<String, Context> serviceContext = new HashMap<String, Context>();
            Context authContext = new Context();
            authContext.put(Service.queryAuthUser, (Object)"allowed");
            authContext.put(Service.queryAuthPwd, (Object)"password");
            serviceContext.put(authUrlRoot, authContext);
            ctx.put(Service.serviceContext, serviceContext);
            qe.setAuthenticator((HttpAuthenticator)new ServiceAuthenticator());
            Assert.assertTrue((boolean)qe.execAsk());
        }
        finally {
            ctx.remove(Service.serviceContext);
        }
    }

    @Test
    public void query_with_auth_12() {
        ARQ.getContext().remove(Service.serviceContext);
        QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)authServiceQuery, (String)"ASK { }");
        qe.setAuthenticator((HttpAuthenticator)new ServiceAuthenticator("allowed", "password".toCharArray()));
        Assert.assertTrue((boolean)qe.execAsk());
    }

    @Test
    public void query_with_auth_13() throws URISyntaxException {
        QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)authServiceQuery, (String)"ASK { }");
        ScopedAuthenticator authenticator = new ScopedAuthenticator(new URI(authUrlRoot), "allowed", "password".toCharArray());
        qe.setAuthenticator((HttpAuthenticator)authenticator);
        Assert.assertTrue((boolean)qe.execAsk());
    }

    @Test
    public void query_with_auth_14() throws URISyntaxException {
        QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)authServiceQuery, (String)"ASK { }");
        ScopedAuthenticator authenticator = new ScopedAuthenticator(new URI("http://localhost:3645"), "allowed", "password".toCharArray());
        qe.setAuthenticator((HttpAuthenticator)authenticator);
        Assert.assertTrue((boolean)qe.execAsk());
    }

    @Test(expected=HttpException.class)
    public void update_with_auth_01() {
        UpdateRequest updates = UpdateFactory.create((String)"CREATE SILENT GRAPH <http://graph>");
        UpdateProcessRemoteBase ue = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemote((UpdateRequest)updates, (String)authServiceUpdate);
        ue.execute();
    }

    @Test(expected=HttpException.class)
    public void update_with_auth_02() {
        UpdateRequest updates = UpdateFactory.create((String)"CREATE SILENT GRAPH <http://graph>");
        UpdateProcessRemoteBase ue = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemote((UpdateRequest)updates, (String)authServiceUpdate);
        ue.setAuthentication("allowed", "incorrect".toCharArray());
        ue.execute();
    }

    @Test
    public void update_with_auth_03() {
        UpdateRequest updates = UpdateFactory.create((String)"CREATE SILENT GRAPH <http://graph>");
        UpdateProcessRemoteBase ue = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemote((UpdateRequest)updates, (String)authServiceUpdate);
        ue.setAuthentication("allowed", "password".toCharArray());
        ue.execute();
    }

    @Test(expected=HttpException.class)
    public void update_with_auth_04() {
        UpdateRequest updates = UpdateFactory.create((String)"CREATE SILENT GRAPH <http://graph>");
        UpdateProcessRemoteBase ue = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemote((UpdateRequest)updates, (String)authServiceUpdate);
        ue.setAuthentication("forbidden", "password".toCharArray());
        ue.execute();
    }

    @Test(expected=HttpException.class)
    public void update_with_auth_05() {
        UpdateRequest updates = UpdateFactory.create((String)"CREATE SILENT GRAPH <http://graph>");
        UpdateProcessRemoteBase ue = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemoteForm((UpdateRequest)updates, (String)authServiceUpdate);
        ue.execute();
    }

    @Test(expected=HttpException.class)
    public void update_with_auth_06() {
        UpdateRequest updates = UpdateFactory.create((String)"CREATE SILENT GRAPH <http://graph>");
        UpdateProcessRemoteBase ue = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemoteForm((UpdateRequest)updates, (String)authServiceUpdate);
        ue.setAuthentication("allowed", "incorrect".toCharArray());
        ue.execute();
    }

    @Test
    public void update_with_auth_07() {
        UpdateRequest updates = UpdateFactory.create((String)"CREATE SILENT GRAPH <http://graph>");
        UpdateProcessRemoteBase ue = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemoteForm((UpdateRequest)updates, (String)authServiceUpdate);
        ue.setAuthentication("allowed", "password".toCharArray());
        ue.execute();
    }

    @Test(expected=HttpException.class)
    public void update_with_auth_08() {
        UpdateRequest updates = UpdateFactory.create((String)"CREATE SILENT GRAPH <http://graph>");
        UpdateProcessRemoteBase ue = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemoteForm((UpdateRequest)updates, (String)authServiceUpdate);
        ue.setAuthentication("forbidden", "password".toCharArray());
        ue.execute();
    }

    @Test(expected=HttpException.class)
    public void update_with_auth_09() throws URISyntaxException {
        UpdateRequest updates = UpdateFactory.create((String)"CREATE SILENT GRAPH <http://graph>");
        UpdateProcessRemoteBase ue = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemote((UpdateRequest)updates, (String)authServiceUpdate);
        ScopedAuthenticator authenticator = new ScopedAuthenticator(new URI("http://example"), "allowed", "password".toCharArray());
        ue.setAuthenticator((HttpAuthenticator)authenticator);
        ue.execute();
    }

    @Test
    public void update_with_auth_10() throws URISyntaxException {
        UpdateRequest updates = UpdateFactory.create((String)"CREATE SILENT GRAPH <http://graph>");
        UpdateProcessRemoteBase ue = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemote((UpdateRequest)updates, (String)authServiceUpdate);
        ScopedAuthenticator authenticator = new ScopedAuthenticator(new URI(authServiceUpdate), "allowed", "password".toCharArray());
        ue.setAuthenticator((HttpAuthenticator)authenticator);
        ue.execute();
    }

    @Test
    public void update_with_auth_11() throws URISyntaxException {
        UpdateRequest updates = UpdateFactory.create((String)"CREATE SILENT GRAPH <http://graph>");
        UpdateProcessRemoteBase ue = (UpdateProcessRemoteBase)UpdateExecutionFactory.createRemote((UpdateRequest)updates, (String)authServiceUpdate);
        ScopedAuthenticator authenticator = new ScopedAuthenticator(new URI(authServiceUpdate), "allowed", "password".toCharArray());
        ue.setAuthenticator((HttpAuthenticator)new PreemptiveBasicAuthenticator((HttpAuthenticator)authenticator));
        ue.execute();
    }

    @Test(expected=HttpException.class)
    public void graphstore_with_auth_01() {
        DatasetAccessor accessor = DatasetAccessorFactory.createHTTP((String)authServiceREST);
        accessor.getModel();
    }

    @Test(expected=HttpException.class)
    public void graphstore_with_auth_02() {
        DatasetAccessor accessor = DatasetAccessorFactory.createHTTP((String)authServiceREST, (HttpAuthenticator)new SimpleAuthenticator("allowed", "incorrect".toCharArray()));
        accessor.getModel();
    }

    @Test
    public void graphstore_with_auth_03() {
        DatasetAccessor accessor = DatasetAccessorFactory.createHTTP((String)authServiceREST, (HttpAuthenticator)new SimpleAuthenticator("allowed", "password".toCharArray()));
        Model m = accessor.getModel();
        Assert.assertTrue((boolean)m.isEmpty());
    }

    @Test(expected=HttpException.class)
    public void graphstore_with_auth_04() throws URISyntaxException {
        DatasetAccessor accessor = DatasetAccessorFactory.createHTTP((String)authServiceREST, (HttpAuthenticator)new ScopedAuthenticator(new URI("http://example.org/"), "allowed", "password".toCharArray()));
        accessor.getModel();
    }

    @Test
    public void graphstore_with_auth_05() throws URISyntaxException {
        DatasetAccessor accessor = DatasetAccessorFactory.createHTTP((String)authServiceREST, (HttpAuthenticator)new ScopedAuthenticator(new URI(authServiceREST), "allowed", "password".toCharArray()));
        accessor.getModel();
    }
}

