/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.modify.request.Target;
import com.hp.hpl.jena.sparql.modify.request.UpdateDrop;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.update.UpdateProcessor;
import org.apache.jena.fuseki.EmbeddedFusekiServer;

public class ServerTest {
    public static final int port = 3635;
    public static final String urlRoot = "http://localhost:3635/";
    public static final String datasetPath = "/dataset";
    public static final String serviceUpdate = "http://localhost:3635/dataset/update";
    public static final String serviceQuery = "http://localhost:3635/dataset/query";
    public static final String serviceREST = "http://localhost:3635/dataset/data";
    public static final String gn1 = "http://graph/1";
    public static final String gn2 = "http://graph/2";
    public static final String gn99 = "http://graph/99";
    public static final Node n1 = NodeFactory.createURI((String)"http://graph/1");
    public static final Node n2 = NodeFactory.createURI((String)"http://graph/2");
    public static final Node n99 = NodeFactory.createURI((String)"http://graph/99");
    public static final Graph graph1 = SSE.parseGraph((String)"(base <http://example/> (graph (<x> <p> 1)))");
    public static final Graph graph2 = SSE.parseGraph((String)"(base <http://example/> (graph (<x> <p> 2)))");
    public static final Model model1 = ModelFactory.createModelForGraph((Graph)graph1);
    public static final Model model2 = ModelFactory.createModelForGraph((Graph)graph2);
    private static EmbeddedFusekiServer server = null;
    private static int countServer = 0;

    public static void allocServer() {
        if (countServer == 0) {
            ServerTest.setupServer();
        }
        ++countServer;
    }

    public static void freeServer() {
        if (countServer >= 0 && --countServer == 0) {
            ServerTest.teardownServer();
        }
    }

    protected static void setupServer() {
        DatasetGraph dsg = DatasetGraphFactory.createMem();
        server = EmbeddedFusekiServer.create((int)3635, (DatasetGraph)dsg, (String)datasetPath);
        server.start();
    }

    protected static void teardownServer() {
        if (server != null) {
            server.stop();
        }
        server = null;
    }

    public static void resetServer() {
        UpdateDrop clearRequest = new UpdateDrop(Target.ALL);
        UpdateProcessor proc = UpdateExecutionFactory.createRemote((Update)clearRequest, (String)serviceUpdate);
        proc.execute();
    }
}

