/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.zookeeper.Login;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperSaslServer {
    public static final String LOGIN_CONTEXT_NAME_KEY = "zookeeper.sasl.serverconfig";
    public static final String DEFAULT_LOGIN_CONTEXT_NAME = "Server";
    Logger LOG = LoggerFactory.getLogger(ZooKeeperSaslServer.class);
    private SaslServer saslServer;

    ZooKeeperSaslServer(Login login) {
        this.saslServer = this.createSaslServer(login);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SaslServer createSaslServer(final Login login) {
        Login login2 = login;
        synchronized (login2) {
            Subject subject = login.getSubject();
            if (subject != null) {
                if (subject.getPrincipals().size() > 0) {
                    try {
                        Object[] principals = subject.getPrincipals().toArray();
                        Principal servicePrincipal = (Principal)principals[0];
                        String servicePrincipalNameAndHostname = servicePrincipal.getName();
                        int indexOf = servicePrincipalNameAndHostname.indexOf("/");
                        final String servicePrincipalName = servicePrincipalNameAndHostname.substring(0, indexOf);
                        String serviceHostnameAndKerbDomain = servicePrincipalNameAndHostname.substring(indexOf + 1, servicePrincipalNameAndHostname.length());
                        indexOf = serviceHostnameAndKerbDomain.indexOf("@");
                        final String serviceHostname = serviceHostnameAndKerbDomain.substring(0, indexOf);
                        String mech = "GSSAPI";
                        this.LOG.debug("serviceHostname is '" + serviceHostname + "'");
                        this.LOG.debug("servicePrincipalName is " + servicePrincipalName + "'");
                        this.LOG.debug("SASL mechanism(mech) is GSSAPI'");
                        try {
                            return Subject.doAs(subject, new PrivilegedExceptionAction<SaslServer>(){

                                @Override
                                public SaslServer run() {
                                    try {
                                        SaslServer saslServer = Sasl.createSaslServer("GSSAPI", servicePrincipalName, serviceHostname, null, login.callbackHandler);
                                        return saslServer;
                                    }
                                    catch (SaslException e2) {
                                        ZooKeeperSaslServer.this.LOG.error("Zookeeper Server failed to create a SaslServer to interact with a client during session initiation: " + e2);
                                        e2.printStackTrace();
                                        return null;
                                    }
                                }
                            });
                        }
                        catch (PrivilegedActionException e2) {
                            this.LOG.error("Zookeeper Quorum member experienced a PrivilegedActionException exception while creating a SaslServer using a JAAS principal context:" + e2);
                            e2.printStackTrace();
                        }
                    }
                    catch (Exception e3) {
                        this.LOG.error("server principal name/hostname determination error: " + e3);
                    }
                } else {
                    try {
                        SaslServer saslServer = Sasl.createSaslServer("DIGEST-MD5", "zookeeper", "zk-sasl-md5", null, login.callbackHandler);
                        return saslServer;
                    }
                    catch (SaslException e4) {
                        this.LOG.error("Zookeeper Quorum member failed to create a SaslServer to interact with a client during session initiation: " + e4);
                    }
                }
            }
        }
        this.LOG.error("failed to create saslServer object.");
        return null;
    }

    public byte[] evaluateResponse(byte[] response) throws SaslException {
        return this.saslServer.evaluateResponse(response);
    }

    public boolean isComplete() {
        return this.saslServer.isComplete();
    }

    public String getAuthorizationID() {
        return this.saslServer.getAuthorizationID();
    }
}

