/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.mgt;

import java.io.Serializable;
import java.util.Collection;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.util.LifecycleUtils;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSessionStorageEvaluator;
import org.apache.shiro.web.mgt.DefaultWebSubjectFactory;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.session.mgt.DefaultWebSessionContext;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.session.mgt.ServletContainerSessionManager;
import org.apache.shiro.web.session.mgt.WebSessionKey;
import org.apache.shiro.web.session.mgt.WebSessionManager;
import org.apache.shiro.web.subject.WebSubject;
import org.apache.shiro.web.subject.WebSubjectContext;
import org.apache.shiro.web.subject.support.DefaultWebSubjectContext;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWebSecurityManager
extends DefaultSecurityManager
implements WebSecurityManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebSecurityManager.class);
    @Deprecated
    public static final String HTTP_SESSION_MODE = "http";
    @Deprecated
    public static final String NATIVE_SESSION_MODE = "native";
    @Deprecated
    private String sessionMode;

    public DefaultWebSecurityManager() {
        ((DefaultSubjectDAO)this.subjectDAO).setSessionStorageEvaluator(new DefaultWebSessionStorageEvaluator());
        this.sessionMode = HTTP_SESSION_MODE;
        this.setSubjectFactory(new DefaultWebSubjectFactory());
        this.setRememberMeManager(new CookieRememberMeManager());
        this.setSessionManager(new ServletContainerSessionManager());
    }

    public DefaultWebSecurityManager(Realm singleRealm) {
        this();
        this.setRealm(singleRealm);
    }

    public DefaultWebSecurityManager(Collection<Realm> realms) {
        this();
        this.setRealms(realms);
    }

    @Override
    protected SubjectContext createSubjectContext() {
        return new DefaultWebSubjectContext();
    }

    @Override
    public void setSubjectDAO(SubjectDAO subjectDAO) {
        super.setSubjectDAO(subjectDAO);
        this.applySessionManagerToSessionStorageEvaluatorIfPossible();
    }

    @Override
    protected void afterSessionManagerSet() {
        super.afterSessionManagerSet();
        this.applySessionManagerToSessionStorageEvaluatorIfPossible();
    }

    private void applySessionManagerToSessionStorageEvaluatorIfPossible() {
        SessionStorageEvaluator evaluator;
        SubjectDAO subjectDAO = this.getSubjectDAO();
        if (subjectDAO instanceof DefaultSubjectDAO && (evaluator = ((DefaultSubjectDAO)subjectDAO).getSessionStorageEvaluator()) instanceof DefaultWebSessionStorageEvaluator) {
            ((DefaultWebSessionStorageEvaluator)evaluator).setSessionManager(this.getSessionManager());
        }
    }

    @Override
    protected SubjectContext copy(SubjectContext subjectContext) {
        if (subjectContext instanceof WebSubjectContext) {
            return new DefaultWebSubjectContext((WebSubjectContext)subjectContext);
        }
        return super.copy(subjectContext);
    }

    @Deprecated
    public String getSessionMode() {
        return this.sessionMode;
    }

    @Deprecated
    public void setSessionMode(String sessionMode) {
        log.warn("The 'sessionMode' property has been deprecated.  Please configure an appropriate WebSessionManager instance instead of using this property.  This property/method will be removed in a later version.");
        String mode = sessionMode;
        if (mode == null) {
            throw new IllegalArgumentException("sessionMode argument cannot be null.");
        }
        mode = sessionMode.toLowerCase();
        if (!HTTP_SESSION_MODE.equals(mode) && !NATIVE_SESSION_MODE.equals(mode)) {
            String msg = "Invalid sessionMode [" + sessionMode + "].  Allowed values are " + "public static final String constants in the " + this.getClass().getName() + " class: '" + HTTP_SESSION_MODE + "' or '" + NATIVE_SESSION_MODE + "', with '" + HTTP_SESSION_MODE + "' being the default.";
            throw new IllegalArgumentException(msg);
        }
        boolean recreate = this.sessionMode == null || !this.sessionMode.equals(mode);
        this.sessionMode = mode;
        if (recreate) {
            LifecycleUtils.destroy(this.getSessionManager());
            SessionManager sessionManager = this.createSessionManager(mode);
            this.setInternalSessionManager(sessionManager);
        }
    }

    @Override
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionMode = null;
        if (sessionManager != null && !(sessionManager instanceof WebSessionManager) && log.isWarnEnabled()) {
            String msg = "The " + this.getClass().getName() + " implementation expects SessionManager instances " + "that implement the " + WebSessionManager.class.getName() + " interface.  The " + "configured instance is of type [" + sessionManager.getClass().getName() + "] which does not " + "implement this interface..  This may cause unexpected behavior.";
            log.warn(msg);
        }
        this.setInternalSessionManager(sessionManager);
    }

    private void setInternalSessionManager(SessionManager sessionManager) {
        super.setSessionManager(sessionManager);
    }

    @Override
    public boolean isHttpSessionMode() {
        SessionManager sessionManager = this.getSessionManager();
        return sessionManager instanceof WebSessionManager && ((WebSessionManager)sessionManager).isServletContainerSessions();
    }

    protected SessionManager createSessionManager(String sessionMode) {
        if (sessionMode == null || !sessionMode.equalsIgnoreCase(NATIVE_SESSION_MODE)) {
            log.info("{} mode - enabling ServletContainerSessionManager (HTTP-only Sessions)", (Object)HTTP_SESSION_MODE);
            return new ServletContainerSessionManager();
        }
        log.info("{} mode - enabling DefaultWebSessionManager (non-HTTP and HTTP Sessions)", (Object)NATIVE_SESSION_MODE);
        return new DefaultWebSessionManager();
    }

    @Override
    protected SessionContext createSessionContext(SubjectContext subjectContext) {
        SessionContext sessionContext = super.createSessionContext(subjectContext);
        if (subjectContext instanceof WebSubjectContext) {
            WebSubjectContext wsc = (WebSubjectContext)subjectContext;
            ServletRequest request = wsc.resolveServletRequest();
            ServletResponse response = wsc.resolveServletResponse();
            DefaultWebSessionContext webSessionContext = new DefaultWebSessionContext(sessionContext);
            if (request != null) {
                webSessionContext.setServletRequest(request);
            }
            if (response != null) {
                webSessionContext.setServletResponse(response);
            }
            sessionContext = webSessionContext;
        }
        return sessionContext;
    }

    @Override
    protected SessionKey getSessionKey(SubjectContext context) {
        if (WebUtils.isWeb(context)) {
            Serializable sessionId = context.getSessionId();
            ServletRequest request = WebUtils.getRequest(context);
            ServletResponse response = WebUtils.getResponse(context);
            return new WebSessionKey(sessionId, request, response);
        }
        return super.getSessionKey(context);
    }

    @Override
    protected void beforeLogout(Subject subject) {
        super.beforeLogout(subject);
        this.removeRequestIdentity(subject);
    }

    protected void removeRequestIdentity(Subject subject) {
        WebSubject webSubject;
        ServletRequest request;
        if (subject instanceof WebSubject && (request = (webSubject = (WebSubject)subject).getServletRequest()) != null) {
            request.setAttribute(ShiroHttpServletRequest.IDENTITY_REMOVED_KEY, Boolean.TRUE);
        }
    }
}

