/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;

public class SegmentCommitInfo {
    public final SegmentInfo info;
    private int delCount;
    private long delGen;
    private long nextWriteDelGen;
    private long fieldInfosGen;
    private long nextWriteFieldInfosGen;
    private final Map<Long, Set<String>> genUpdatesFiles = new HashMap<Long, Set<String>>();
    private volatile long sizeInBytes = -1L;
    private long bufferedDeletesGen;

    public SegmentCommitInfo(SegmentInfo info, int delCount, long delGen, long fieldInfosGen) {
        this.info = info;
        this.delCount = delCount;
        this.delGen = delGen;
        this.nextWriteDelGen = delGen == -1L ? 1L : delGen + 1L;
        this.fieldInfosGen = fieldInfosGen;
        this.nextWriteFieldInfosGen = fieldInfosGen == -1L ? 1L : fieldInfosGen + 1L;
    }

    public Map<Long, Set<String>> getUpdatesFiles() {
        return Collections.unmodifiableMap(this.genUpdatesFiles);
    }

    public void setGenUpdatesFiles(Map<Long, Set<String>> genUpdatesFiles) {
        this.genUpdatesFiles.clear();
        this.genUpdatesFiles.putAll(genUpdatesFiles);
    }

    void advanceDelGen() {
        this.delGen = this.nextWriteDelGen;
        this.nextWriteDelGen = this.delGen + 1L;
        this.sizeInBytes = -1L;
    }

    void advanceNextWriteDelGen() {
        ++this.nextWriteDelGen;
    }

    void advanceFieldInfosGen() {
        this.fieldInfosGen = this.nextWriteFieldInfosGen;
        this.nextWriteFieldInfosGen = this.fieldInfosGen + 1L;
        this.sizeInBytes = -1L;
    }

    void advanceNextWriteFieldInfosGen() {
        ++this.nextWriteFieldInfosGen;
    }

    public long sizeInBytes() throws IOException {
        if (this.sizeInBytes == -1L) {
            long sum = 0L;
            for (String fileName : this.files()) {
                sum += this.info.dir.fileLength(fileName);
            }
            this.sizeInBytes = sum;
        }
        return this.sizeInBytes;
    }

    public Collection<String> files() throws IOException {
        HashSet<String> files = new HashSet<String>(this.info.files());
        this.info.getCodec().liveDocsFormat().files(this, files);
        for (Set<String> updateFiles : this.genUpdatesFiles.values()) {
            files.addAll(updateFiles);
        }
        return files;
    }

    long getBufferedDeletesGen() {
        return this.bufferedDeletesGen;
    }

    void setBufferedDeletesGen(long v) {
        this.bufferedDeletesGen = v;
        this.sizeInBytes = -1L;
    }

    public boolean hasDeletions() {
        return this.delGen != -1L;
    }

    public boolean hasFieldUpdates() {
        return this.fieldInfosGen != -1L;
    }

    public long getNextFieldInfosGen() {
        return this.nextWriteFieldInfosGen;
    }

    public long getFieldInfosGen() {
        return this.fieldInfosGen;
    }

    public long getNextDelGen() {
        return this.nextWriteDelGen;
    }

    public long getDelGen() {
        return this.delGen;
    }

    public int getDelCount() {
        return this.delCount;
    }

    void setDelCount(int delCount) {
        this.delCount = delCount;
        assert (delCount <= this.info.getDocCount());
    }

    public String toString(Directory dir, int pendingDelCount) {
        String s = this.info.toString(dir, this.delCount + pendingDelCount);
        if (this.delGen != -1L) {
            s = s + ":delGen=" + this.delGen;
        }
        if (this.fieldInfosGen != -1L) {
            s = s + ":fieldInfosGen=" + this.fieldInfosGen;
        }
        return s;
    }

    public String toString() {
        return this.toString(this.info.dir, 0);
    }

    public SegmentCommitInfo clone() {
        SegmentCommitInfo other = new SegmentCommitInfo(this.info, this.delCount, this.delGen, this.fieldInfosGen);
        other.nextWriteDelGen = this.nextWriteDelGen;
        other.nextWriteFieldInfosGen = this.nextWriteFieldInfosGen;
        for (Map.Entry<Long, Set<String>> e2 : this.genUpdatesFiles.entrySet()) {
            other.genUpdatesFiles.put(e2.getKey(), new HashSet(e2.getValue()));
        }
        return other;
    }
}

