/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.FilteringTokenFilter;
import org.apache.lucene.util.Version;

public final class CodepointCountFilter
extends FilteringTokenFilter {
    private final int min;
    private final int max;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public CodepointCountFilter(Version version2, TokenStream in, int min2, int max2) {
        super(version2, in);
        this.min = min2;
        this.max = max2;
    }

    @Override
    public boolean accept() {
        int max32 = this.termAtt.length();
        int min32 = max32 >> 1;
        if (min32 >= this.min && max32 <= this.max) {
            return true;
        }
        if (min32 > this.max || max32 < this.min) {
            return false;
        }
        int len = Character.codePointCount(this.termAtt.buffer(), 0, this.termAtt.length());
        return len >= this.min && len <= this.max;
    }
}

