/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.thrift;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.thrift.ThriftConvert;
import org.apache.jena.riot.thrift.VisitorStreamRowTRDF;
import org.apache.jena.riot.thrift.wire.RDF_PrefixDecl;
import org.apache.jena.riot.thrift.wire.RDF_Quad;
import org.apache.jena.riot.thrift.wire.RDF_Triple;

public class Thrift2StreamRDF
implements VisitorStreamRowTRDF {
    private final StreamRDF dest;
    private final PrefixMap pmap;

    public Thrift2StreamRDF(PrefixMap pmap, StreamRDF stream) {
        this.pmap = pmap;
        this.dest = stream;
    }

    @Override
    public void visit(RDF_Triple rt) {
        Triple t = ThriftConvert.convert(rt, this.pmap);
        this.dest.triple(t);
    }

    @Override
    public void visit(RDF_Quad rq) {
        Quad q = ThriftConvert.convert(rq, this.pmap);
        this.dest.quad(q);
    }

    @Override
    public void visit(RDF_PrefixDecl prefixDecl) {
        String prefix = prefixDecl.getPrefix();
        String iriStr = prefixDecl.getUri();
        try {
            this.pmap.add(prefix, iriStr);
        }
        catch (RiotException ex) {
            // empty catch block
        }
        this.dest.prefix(prefix, iriStr);
    }
}

