/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.StreamRDF;

public class StreamOps {
    public static void datasetToStream(DatasetGraph datasetGraph, StreamRDF stream) {
        stream.start();
        StreamOps.sendDatasetToStream(datasetGraph, stream);
        stream.finish();
    }

    public static void graphToStream(Graph graph, StreamRDF stream) {
        stream.start();
        StreamOps.sendGraphToStream(graph, stream);
        stream.finish();
    }

    public static void sendPrefixesToStream(PrefixMap prefixMap, StreamRDF stream) {
        for (Map.Entry<String, String> e2 : prefixMap.getMappingCopyStr().entrySet()) {
            stream.prefix(e2.getKey(), e2.getValue());
        }
    }

    public static void sendPrefixesToStream(PrefixMapping prefixMap, StreamRDF stream) {
        for (Map.Entry<String, String> e2 : prefixMap.getNsPrefixMap().entrySet()) {
            stream.prefix(e2.getKey(), e2.getValue());
        }
    }

    public static void sendTriplesQuadsToStream(DatasetGraph datasetGraph, StreamRDF stream) {
        StreamOps.sendDatasetToStream(datasetGraph, stream, null);
    }

    public static void sendDatasetToStream(DatasetGraph datasetGraph, StreamRDF stream) {
        PrefixMap prefixMap = PrefixMapFactory.create(datasetGraph.getDefaultGraph().getPrefixMapping());
        StreamOps.sendDatasetToStream(datasetGraph, stream, prefixMap);
    }

    public static void sendDatasetToStream(DatasetGraph datasetGraph, StreamRDF stream, PrefixMap prefixMap) {
        if (prefixMap != null) {
            StreamOps.sendPrefixesToStream(prefixMap, stream);
        }
        ExtendedIterator<Triple> iter1 = datasetGraph.getDefaultGraph().find(null, null, null);
        StreamOps.sendTriplesToStream(iter1, stream);
        Iterator<Quad> iter2 = datasetGraph.findNG(null, null, null, null);
        StreamOps.sendQuadsToStream(iter2, stream);
    }

    public static void sendGraphToStream(Graph graph, StreamRDF stream) {
        PrefixMap prefixMap = PrefixMapFactory.create(graph.getPrefixMapping());
        StreamOps.sendGraphToStream(graph, stream, prefixMap);
    }

    public static void sendGraphToStream(Graph graph, StreamRDF stream, PrefixMap prefixMap) {
        if (prefixMap != null) {
            StreamOps.sendPrefixesToStream(graph.getPrefixMapping(), stream);
        }
        ExtendedIterator<Triple> iter = graph.find(null, null, null);
        StreamOps.sendTriplesToStream(iter, stream);
    }

    public static void sendTriplesToStream(Graph graph, StreamRDF stream) {
        StreamOps.sendGraphToStream(graph, stream, null);
    }

    public static void sendTriplesToStream(Iterator<Triple> iter, StreamRDF dest) {
        while (iter.hasNext()) {
            Triple t = iter.next();
            dest.triple(t);
        }
    }

    public static void sendQuadsToStream(DatasetGraph datasetGraph, StreamRDF stream) {
        Iterator<Quad> iter2 = datasetGraph.find(null, null, null, null);
        StreamOps.sendQuadsToStream(iter2, stream);
    }

    public static void sendQuadsToStream(Iterator<Quad> iter, StreamRDF dest) {
        while (iter.hasNext()) {
            Quad q = iter.next();
            dest.quad(q);
        }
    }
}

