/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.process.inf;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import org.apache.jena.riot.process.inf.InferenceProcessorRDFS;
import org.apache.jena.riot.process.inf.InferenceSetupRDFS;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWrapper;

public class InferenceProcessorStreamRDF
extends StreamRDFWrapper {
    private final InferenceSetupRDFS rdfsSetup;
    private final InferenceProcessorRDFS rdfs;
    private boolean isTriple = true;
    private Node g;

    public InferenceProcessorStreamRDF(final StreamRDF output, InferenceSetupRDFS rdfsSetup) {
        super(output);
        this.rdfsSetup = rdfsSetup;
        this.rdfs = new InferenceProcessorRDFS(rdfsSetup){

            @Override
            public void derive(Node s, Node p, Node o) {
                if (InferenceProcessorStreamRDF.this.isTriple) {
                    output.triple(Triple.create(s, p, o));
                } else {
                    output.quad(Quad.create(InferenceProcessorStreamRDF.this.g, s, p, o));
                }
            }
        };
    }

    @Override
    public void triple(Triple triple) {
        super.triple(triple);
        this.isTriple = true;
        this.g = null;
        this.rdfs.process(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    @Override
    public void quad(Quad quad) {
        super.quad(quad);
        this.isTriple = false;
        this.g = quad.getGraph();
        this.rdfs.process(quad.getSubject(), quad.getPredicate(), quad.getObject());
    }
}

