/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.lib.Metadata;
import com.hp.hpl.jena.sparql.mgt.SystemInfo;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunction;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionFactory;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionRegistry;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.tdb.TDB;
import org.apache.jena.query.text.TextQueryPF;
import org.apache.jena.query.text.assembler.TextAssembler;

public class TextQuery {
    private static boolean initialized = false;
    private static Object lock = new Object();
    public static String NS = "http://jena.apache.org/text#";
    public static String IRI = "http://jena.apache.org/#text";
    public static final Symbol textIndex = Symbol.create(NS + "index");
    public static final String PATH = "org.apache.jena.query.text";
    private static String metadataLocation = "org/apache/jena/query/text/properties.xml";
    private static Metadata metadata = new Metadata(metadataLocation);
    public static final String NAME = "ARQ Text Query";
    public static final String VERSION = metadata.get("org.apache.jena.query.text.version", "unknown");
    public static final String BUILD_DATE = metadata.get("org.apache.jena.query.text.build.datetime", "unset");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (initialized) {
                return;
            }
            initialized = true;
            TDB.init();
            TextAssembler.init();
            SystemInfo sysInfo = new SystemInfo(IRI, PATH, VERSION, BUILD_DATE);
            SystemARQ.registerSubSystem(sysInfo);
            PropertyFunctionRegistry.get().put("http://jena.apache.org/text#query", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new TextQueryPF();
                }
            });
        }
    }

    static {
        TextQuery.init();
    }
}

