/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.query.text.Entity;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextQueryFuncs;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextIndexSolr
implements TextIndex {
    private static final Logger log = LoggerFactory.getLogger(TextIndexSolr.class);
    private final SolrServer solrServer;
    private final EntityDefinition docDef;
    private static final int MAX_N = 10000;

    public TextIndexSolr(SolrServer server, EntityDefinition def) {
        this.solrServer = server;
        this.docDef = def;
    }

    @Override
    public void prepareCommit() {
    }

    @Override
    public void commit() {
        try {
            this.solrServer.commit();
        }
        catch (SolrServerException e2) {
            throw new TextIndexException(e2);
        }
        catch (IOException e3) {
            throw new TextIndexException(e3);
        }
    }

    @Override
    public void rollback() {
        try {
            this.solrServer.rollback();
        }
        catch (SolrServerException e2) {
            throw new TextIndexException(e2);
        }
        catch (IOException e3) {
            throw new TextIndexException(e3);
        }
    }

    @Override
    public void close() {
        if (this.solrServer != null) {
            this.solrServer.shutdown();
        }
    }

    @Override
    public void addEntity(Entity entity) {
        try {
            SolrInputDocument doc = this.solrDoc(entity);
            this.solrServer.add(doc);
        }
        catch (Exception e2) {
            TextIndexSolr.exception(e2);
        }
    }

    private SolrInputDocument solrDoc(Entity entity) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField(this.docDef.getEntityField(), entity.getId());
        String graphField = this.docDef.getGraphField();
        if (graphField != null) {
            doc.addField(graphField, entity.getGraph());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e2 : entity.getMap().entrySet()) {
            map.put("add", e2.getValue());
            doc.addField(e2.getKey(), map);
        }
        return doc;
    }

    @Override
    public Map<String, Node> get(String uri) {
        String escaped = ClientUtils.escapeQueryChars(uri);
        String qs = this.docDef.getEntityField() + ":" + escaped;
        SolrDocumentList solrResults = this.solrQuery(qs, 1);
        List<Map<String, Node>> records = this.process(solrResults);
        if (records.size() == 0) {
            return null;
        }
        if (records.size() > 1) {
            log.warn("Multiple docs for one URI: " + uri);
        }
        return records.get(0);
    }

    private List<Map<String, Node>> process(SolrDocumentList solrResults) {
        ArrayList<Map<String, Node>> records = new ArrayList<Map<String, Node>>();
        for (SolrDocument sd : solrResults) {
            HashMap<String, Node> record = new HashMap<String, Node>();
            String uriStr = (String)sd.getFieldValue(this.docDef.getEntityField());
            Node entity = NodeFactory.createURI(uriStr);
            record.put(this.docDef.getEntityField(), entity);
            for (String f : this.docDef.fields()) {
                Object obj = sd.getFieldValue(f);
                if (obj == null) continue;
                if (obj instanceof List) {
                    List vals = (List)obj;
                    continue;
                }
                String v = (String)obj;
                Node n = this.entryToNode(v);
                record.put(f, n);
            }
            records.add(record);
        }
        return records;
    }

    @Override
    public List<Node> query(String qs) {
        return this.query(qs, 0);
    }

    @Override
    public List<Node> query(String qs, int limit) {
        SolrDocumentList solrResults = this.solrQuery(qs, limit);
        List<Node> results = new ArrayList<Node>();
        for (SolrDocument sd : solrResults) {
            String str2 = (String)sd.getFieldValue(this.docDef.getEntityField());
            Node n = TextQueryFuncs.stringToNode(str2);
            results.add(n);
        }
        if (limit > 0 && results.size() > limit) {
            results = results.subList(0, limit);
        }
        return results;
    }

    private SolrDocumentList solrQuery(String qs, int limit) {
        SolrQuery sq2 = new SolrQuery(qs);
        if (limit > 0) {
            sq2.setRows(limit);
        } else {
            sq2.setRows(10000);
        }
        try {
            sq2.add("df", this.docDef.getPrimaryField());
            QueryResponse rsp = this.solrServer.query(sq2);
            SolrDocumentList docs = rsp.getResults();
            return docs;
        }
        catch (SolrServerException e2) {
            TextIndexSolr.exception(e2);
            return null;
        }
    }

    @Override
    public EntityDefinition getDocDef() {
        return this.docDef;
    }

    private Node entryToNode(String v) {
        return NodeFactoryExtra.createLiteralNode(v, null, null);
    }

    public SolrServer getServer() {
        return this.solrServer;
    }

    private static Void exception(Exception ex) {
        throw new TextIndexException(ex);
    }
}

