/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial.pfunction;

import com.spatial4j.core.shape.Shape;
import org.apache.jena.query.spatial.DistanceUnitsUtils;
import org.apache.jena.query.spatial.SpatialQuery;
import org.apache.lucene.spatial.query.SpatialOperation;

public class SpatialMatch {
    private final Shape shape;
    private final int limit;
    private final SpatialOperation operation;

    public SpatialMatch(Double latitude, Double longitude, Double radius, String units, int limit, SpatialOperation operation) {
        double degrees = DistanceUnitsUtils.dist2Degrees(radius, units);
        this.shape = SpatialQuery.ctx.makeCircle(longitude, latitude, degrees);
        this.limit = limit;
        this.operation = operation;
    }

    public SpatialMatch(Double latitude1, Double longitude1, Double latitude2, Double longitude2, int limit, SpatialOperation operation) {
        this.shape = SpatialQuery.ctx.makeRectangle(longitude1, longitude2, latitude1, latitude2);
        this.limit = limit;
        this.operation = operation;
    }

    public Shape getShape() {
        return this.shape;
    }

    public int getLimit() {
        return this.limit;
    }

    public SpatialOperation getSpatialOperation() {
        return this.operation;
    }

    public String toString() {
        return "(" + this.shape + " " + this.limit + " " + this.operation + ")";
    }
}

