/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.query.spatial.EntityDefinition;
import org.apache.jena.query.spatial.SpatialDatasetFactory;
import org.apache.jena.query.spatial.SpatialIndex;
import org.apache.jena.query.spatial.SpatialIndexException;
import org.apache.jena.query.spatial.assembler.SpatialVocab;
import org.apache.solr.client.solrj.impl.HttpSolrServer;

public class SpatialIndexSolrAssembler
extends AssemblerBase {
    @Override
    public SpatialIndex open(Assembler a, Resource root, Mode mode) {
        String uri = GraphUtils.getResourceValue(root, SpatialVocab.pServer).getURI();
        if (uri.startsWith("embedded:")) {
            throw new SpatialIndexException("Embedded Solr server not supported (change code and dependencies to enable)");
        }
        if (!uri.startsWith("http://")) {
            throw new SpatialIndexException("URI for the server must begin 'http://'");
        }
        HttpSolrServer server = new HttpSolrServer(uri);
        Resource r = GraphUtils.getResourceValue(root, SpatialVocab.pDefinition);
        EntityDefinition docDef = (EntityDefinition)a.open(r);
        return SpatialDatasetFactory.createSolrIndex(server, docDef);
    }
}

