/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import com.spatial4j.core.shape.Shape;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.query.spatial.EntityDefinition;
import org.apache.jena.query.spatial.SpatialIndex;
import org.apache.jena.query.spatial.SpatialIndexException;
import org.apache.jena.query.spatial.SpatialQuery;
import org.apache.jena.query.spatial.SpatialQueryFuncs;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialIndexSolr
implements SpatialIndex {
    private static Logger log = LoggerFactory.getLogger(SpatialIndexSolr.class);
    private final SolrServer solrServer;
    private EntityDefinition docDef;
    private SpatialPrefixTree grid;
    private SpatialStrategy strategy;

    public SpatialIndexSolr(SolrServer server, EntityDefinition def) {
        this.solrServer = server;
        this.docDef = def;
        int maxLevels = 11;
        this.grid = new GeohashPrefixTree(SpatialQuery.ctx, maxLevels);
        this.strategy = new RecursivePrefixTreeStrategy(this.grid, def.getGeoField());
    }

    @Override
    public void startIndexing() {
    }

    @Override
    public void finishIndexing() {
        try {
            this.solrServer.commit();
        }
        catch (Exception ex) {
            SpatialIndexSolr.exception(ex);
        }
    }

    @Override
    public void abortIndexing() {
        try {
            this.solrServer.rollback();
        }
        catch (Exception ex) {
            SpatialIndexSolr.exception(ex);
        }
    }

    @Override
    public void close() {
        if (this.solrServer != null) {
            this.solrServer.shutdown();
        }
    }

    @Override
    public void add(String entityURI, Shape ... shapes) {
        try {
            SolrInputDocument doc = this.solrDoc(entityURI, shapes);
            this.solrServer.add(doc);
        }
        catch (Exception e2) {
            SpatialIndexSolr.exception(e2);
        }
    }

    private SolrInputDocument solrDoc(String entityURI, Shape ... shapes) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField(this.docDef.getEntityField(), entityURI);
        if (shapes.length != 1) {
            throw new SpatialIndexException("Solr spatial only supports indexing one shape a time, but provided: " + shapes.length + " shapes.");
        }
        doc.addField(this.docDef.getGeoField(), SpatialQuery.ctx.toString(shapes[0]));
        return doc;
    }

    @Override
    public List<Node> query(Shape shape, int limit, SpatialOperation operation) {
        SolrDocumentList solrResults = this.solrQuery(shape, limit, operation);
        List<Node> results = new ArrayList<Node>();
        for (SolrDocument sd : solrResults) {
            String str2 = (String)sd.getFieldValue(this.docDef.getEntityField());
            Node n = SpatialQueryFuncs.stringToNode(str2);
            results.add(n);
        }
        if (limit > 0 && results.size() > limit) {
            results = results.subList(0, limit);
        }
        return results;
    }

    private SolrDocumentList solrQuery(Shape shape, int limit, SpatialOperation operation) {
        SolrQuery sq2 = new SolrQuery();
        sq2.setQuery("*:*");
        sq2.setFilterQueries(this.docDef.getGeoField() + ":\"" + operation.toString() + "(" + SpatialQuery.ctx.toString(shape) + ") distErrPct=0\"");
        try {
            QueryResponse rsp = this.solrServer.query(sq2);
            SolrDocumentList docs = rsp.getResults();
            return docs;
        }
        catch (SolrServerException e2) {
            SpatialIndexSolr.exception(e2);
            return null;
        }
    }

    @Override
    public EntityDefinition getDocDef() {
        return this.docDef;
    }

    private Node entryToNode(String v) {
        return NodeFactoryExtra.createLiteralNode(v, null, null);
    }

    public SolrServer getServer() {
        return this.solrServer;
    }

    private static Void exception(Exception ex) {
        throw new SpatialIndexException(ex);
    }
}

