/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadAction;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.Transform;
import org.apache.jena.query.spatial.SpatialDocProducer;
import org.apache.jena.query.spatial.SpatialIndex;
import org.apache.jena.query.spatial.SpatialIndexContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialDocProducerTriples
implements SpatialDocProducer {
    private static Logger log = LoggerFactory.getLogger(SpatialDocProducerTriples.class);
    private final SpatialIndex indexer;
    private boolean started = false;
    private SpatialIndexContext context = null;
    static Transform<Quad, Triple> QuadsToTriples = new Transform<Quad, Triple>(){

        @Override
        public Triple convert(Quad item) {
            return item.asTriple();
        }
    };

    public SpatialDocProducerTriples(SpatialIndex indexer) {
        this.indexer = indexer;
        this.context = new SpatialIndexContext(indexer);
    }

    @Override
    public void start() {
        this.indexer.startIndexing();
        this.started = true;
    }

    @Override
    public void finish() {
        this.indexer.finishIndexing();
    }

    @Override
    public void change(QuadAction qaction, Node g, Node s, Node p, Node o) {
        if (qaction != QuadAction.ADD) {
            return;
        }
        this.context.index(g, s, p, o);
    }

    private static List<Triple> quadsToTriples(List<Quad> quads) {
        return Iter.map(quads, QuadsToTriples);
    }
}

