/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.spatial4j.core.context.SpatialContextFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.query.spatial.SpatialPredicatePair;
import org.apache.jena.query.spatial.SpatialQuery;

public class EntityDefinition {
    private final String entityField;
    private final String geoField;
    private final Set<Node> WKTPredicates;
    private final Set<Node> builtinWKTPredicates;
    private final Set<SpatialPredicatePair> spatialPredicatePairs;
    private final Set<SpatialPredicatePair> builtinSpatialPredicatePairs;
    private static final String geo_ns = "http://www.w3.org/2003/01/geo/wgs84_pos#";
    public static final Property geo_latitude = ResourceFactory.createProperty("http://www.w3.org/2003/01/geo/wgs84_pos#lat");
    public static final Property geo_longitude = ResourceFactory.createProperty("http://www.w3.org/2003/01/geo/wgs84_pos#long");
    public static final Property geo_geometry = ResourceFactory.createProperty("http://www.w3.org/2003/01/geo/wgs84_pos#geometry");
    public static final Property geosparql_asWKT = ResourceFactory.createProperty("http://www.opengis.net/ont/geosparql#asWKT");
    public static final Resource geosparql_wktLiteral = ResourceFactory.createResource("http://www.opengis.net/ont/geosparql#wktLiteral");

    public EntityDefinition(String entityField, String geoField) {
        this.entityField = entityField == null || entityField.isEmpty() ? "entityField" : entityField;
        this.geoField = geoField == null || geoField.isEmpty() ? "geoField" : geoField;
        this.WKTPredicates = new HashSet<Node>();
        this.builtinWKTPredicates = new HashSet<Node>();
        this.spatialPredicatePairs = new HashSet<SpatialPredicatePair>();
        this.builtinSpatialPredicatePairs = new HashSet<SpatialPredicatePair>();
        this.initBuiltinPredicates();
    }

    public void setSpatialContextFactory(String spatialContextFactoryClass) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("spatialContextFactory", spatialContextFactoryClass);
        SpatialQuery.ctx = SpatialContextFactory.makeSpatialContext(map, SpatialQuery.class.getClassLoader());
    }

    private void initBuiltinPredicates() {
        this.addBuiltinWKTPredicate(geo_geometry);
        this.addBuiltinWKTPredicate(geosparql_asWKT);
        this.addBuiltinSpatialPredicatePair(geo_latitude, geo_longitude);
    }

    private boolean addBuiltinWKTPredicate(Resource predicate) {
        this.builtinWKTPredicates.add(predicate.asNode());
        return this.addWKTPredicate(predicate);
    }

    public boolean addWKTPredicate(Resource predicate) {
        return this.WKTPredicates.add(predicate.asNode());
    }

    private boolean addBuiltinSpatialPredicatePair(Resource latitude_predicate, Resource longitude_predicate) {
        this.builtinSpatialPredicatePairs.add(new SpatialPredicatePair(latitude_predicate.asNode(), longitude_predicate.asNode()));
        return this.addSpatialPredicatePair(latitude_predicate, longitude_predicate);
    }

    public boolean addSpatialPredicatePair(Resource latitude_predicate, Resource longitude_predicate) {
        return this.spatialPredicatePairs.add(new SpatialPredicatePair(latitude_predicate.asNode(), longitude_predicate.asNode()));
    }

    public String getEntityField() {
        return this.entityField;
    }

    public String getGeoField() {
        return this.geoField;
    }

    public boolean isWKTPredicate(Node predicate) {
        return this.WKTPredicates.contains(predicate);
    }

    public boolean isSpatialPredicate(Node predicate) {
        return this.getSpatialPredicatePair(predicate) != null;
    }

    public boolean isLatitudePredicate(Node predicate) {
        return this.getSpatialPredicatePair(predicate).getLatitudePredicate().equals(predicate);
    }

    public SpatialPredicatePair getSpatialPredicatePair(Node predicate) {
        for (SpatialPredicatePair pair : this.spatialPredicatePairs) {
            if (!pair.getLatitudePredicate().equals(predicate) && !pair.getLongitudePredicate().equals(predicate)) continue;
            return pair;
        }
        return null;
    }

    public int getCustomSpatialPredicatePairCount() {
        return this.spatialPredicatePairs.size() - this.builtinSpatialPredicatePairs.size();
    }

    public int getSpatialPredicatePairCount() {
        return this.spatialPredicatePairs.size();
    }

    public int getCustomWKTPredicateCount() {
        return this.WKTPredicates.size() - this.builtinWKTPredicates.size();
    }

    public int getWKTPredicateCount() {
        return this.WKTPredicates.size();
    }

    public boolean hasSpatialPredicatePair(Node latitude_predicate, Node longitude_predicate) {
        for (SpatialPredicatePair pair : this.spatialPredicatePairs) {
            if (!pair.getLatitudePredicate().equals(latitude_predicate) || !pair.getLongitudePredicate().equals(longitude_predicate)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.entityField + ":" + this.geoField;
    }
}

