/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphMonitor;
import com.hp.hpl.jena.sparql.core.DatasetGraphWithLock;
import com.hp.hpl.jena.sparql.core.GraphView;
import com.hp.hpl.jena.sparql.core.Transactional;
import org.apache.jena.query.spatial.SpatialDocProducer;
import org.apache.jena.query.spatial.SpatialIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetGraphSpatial
extends DatasetGraphMonitor
implements Transactional {
    private static Logger log = LoggerFactory.getLogger(DatasetGraphSpatial.class);
    private final SpatialIndex spatialIndex;
    private final Transactional dsgtxn;
    private boolean needFinish = false;

    public DatasetGraphSpatial(DatasetGraph dsg, SpatialIndex index, SpatialDocProducer producer) {
        super(dsg, producer);
        this.spatialIndex = index;
        this.dsgtxn = dsg instanceof Transactional ? (Transactional)((Object)dsg) : new DatasetGraphWithLock(dsg);
    }

    @Override
    public Graph getDefaultGraph() {
        return GraphView.createDefaultGraph(this);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph(this, graphNode);
    }

    public SpatialIndex getSpatialIndex() {
        return this.spatialIndex;
    }

    @Override
    public void begin(ReadWrite readWrite) {
        this.dsgtxn.begin(readWrite);
        if (readWrite == ReadWrite.WRITE) {
            super.getMonitor().start();
            this.needFinish = true;
        }
    }

    @Override
    public void commit() {
        try {
            if (this.needFinish) {
                super.getMonitor().finish();
            }
            this.needFinish = false;
            this.dsgtxn.commit();
        }
        catch (Throwable ex) {
            log.warn("Exception in commit: " + ex.getMessage(), ex);
            this.dsgtxn.abort();
        }
    }

    @Override
    public void abort() {
        try {
            if (this.needFinish) {
                this.spatialIndex.abortIndexing();
            }
            this.dsgtxn.abort();
        }
        catch (Throwable ex) {
            log.warn("Exception in abort: " + ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isInTransaction() {
        return this.dsgtxn.isInTransaction();
    }

    @Override
    public void end() {
        try {
            this.dsgtxn.end();
        }
        catch (Throwable ex) {
            log.warn("Exception in end: " + ex.getMessage(), ex);
        }
    }
}

