/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.Enumeration;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.ServletBase;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.validation.ValidationAction;
import org.apache.jena.web.HttpSC;
import org.slf4j.Logger;

public abstract class ValidatorBaseJson
extends ServletBase {
    private static Logger vLog = Fuseki.validationLog;
    public static final String jErrors = "errors";
    public static final String jWarnings = "warning";
    public static final String jParseError = "parse-error";
    public static final String jParseErrorLine = "parse-error-line";
    public static final String jParseErrorCol = "parse-error-column";
    public static final String respService = "X-Service";

    @Override
    public void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.execute(httpRequest, httpResponse);
    }

    @Override
    public void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.execute(httpRequest, httpResponse);
    }

    protected void execute(HttpServletRequest request, HttpServletResponse response) {
        long id = ValidatorBaseJson.allocRequestId(request, response);
        ValidationAction action = new ValidationAction(id, vLog, request, response, false);
        this.printRequest(action);
        action.setStartTime();
        response = action.response;
        this.initResponse(request, response);
        Context cxt = ARQ.getContext();
        try {
            JsonObject obj = this.execute(action);
            action.statusCode = 200;
            action.message = "OK";
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/json");
            action.response.setStatus(200);
            ServletOutputStream out = response.getOutputStream();
            JSON.write(out, (JsonValue)obj);
        }
        catch (ActionErrorException ex) {
            if (ex.exception != null) {
                ex.exception.printStackTrace(System.err);
            }
            if (ex.message != null) {
                ServletOps.responseSendError(response, ex.rc, ex.message);
            } else {
                ServletOps.responseSendError(response, ex.rc);
            }
        }
        catch (Throwable th) {
            ServletOps.responseSendError(response, 500, "Internal Error");
        }
        action.setFinishTime();
        this.printResponse(action);
    }

    private void initResponse(HttpServletRequest request, HttpServletResponse response) {
        ValidatorBaseJson.setCommonHeaders(response);
        String method = request.getMethod();
        if ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method)) {
            ValidatorBaseJson.setVaryHeader(response);
        }
    }

    private void printRequest(ValidationAction action) {
        String url = ActionLib.wholeRequestURL(action.request);
        String method = action.request.getMethod();
        action.log.info(String.format("[%d] %s %s", action.id, method, url));
        if (action.verbose) {
            Enumeration<String> en = action.request.getHeaderNames();
            while (en.hasMoreElements()) {
                String h = en.nextElement();
                Enumeration<String> vals = action.request.getHeaders(h);
                if (!vals.hasMoreElements()) {
                    action.log.info(String.format("[%d]   ", action.id, h));
                    continue;
                }
                while (vals.hasMoreElements()) {
                    action.log.info(String.format("[%d]   %-20s %s", action.id, h, vals.nextElement()));
                }
            }
        }
    }

    private void printResponse(ValidationAction action) {
        long time = action.getTime();
        HttpServletResponse response = action.response;
        if (action.verbose) {
            // empty if block
        }
        String timeStr = ValidatorBaseJson.fmtMillis(time);
        if (action.message == null) {
            action.log.info(String.format("[%d] %d %s (%s) ", action.id, action.statusCode, HttpSC.getMessage(action.statusCode), timeStr));
        } else {
            action.log.info(String.format("[%d] %d %s (%s) ", action.id, action.statusCode, action.message, timeStr));
        }
    }

    private static String fmtMillis(long time) {
        if (time < 1000L) {
            return String.format("%,d ms", time);
        }
        return String.format("%,.3f s", (double)time / 1000.0);
    }

    protected abstract JsonObject execute(ValidationAction var1);

    protected abstract String validatorName();

    protected void setHeaders(HttpServletResponse httpResponse) {
        httpResponse.setCharacterEncoding("utf-8");
        httpResponse.setContentType("application/json");
        httpResponse.setHeader(respService, "Jena Fuseki Validator / " + this.validatorName() + ": http://jena.apache.org/");
    }

    protected static String getArg(ValidationAction action, String paramName) {
        String arg = ValidatorBaseJson.getArgOrNull(action, paramName);
        if (arg == null) {
            ServletOps.error(400, "No parameter given: " + paramName);
            return null;
        }
        return arg;
    }

    protected static String getArgOrNull(ValidationAction action, String paramName) {
        String[] args = ValidatorBaseJson.getArgs(action, paramName);
        if (args == null || args.length == 0) {
            return null;
        }
        if (args.length > 1) {
            ServletOps.error(400, "Too many (" + args.length + ") parameter values: " + paramName);
            return null;
        }
        return args[0];
    }

    protected static String[] getArgs(ValidationAction action, String paramName) {
        String[] args = action.request.getParameterValues(paramName);
        if (args == null || args.length == 0) {
            return null;
        }
        return args;
    }
}

