/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation;

import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.validation.ValidationAction;
import org.apache.jena.fuseki.validation.ValidatorBaseJson;

public class UpdateValidator
extends ValidatorBaseJson {
    static final String paramUpdate = "update";
    static final String paramSyntax = "languageSyntax";
    static final String jInput = "input";
    static final String jFormatted = "formatted";

    @Override
    protected JsonObject execute(ValidationAction action) {
        Syntax language;
        JsonBuilder obj = new JsonBuilder();
        obj.startObject();
        String updateString = UpdateValidator.getArg(action, paramUpdate);
        String updateSyntax = UpdateValidator.getArgOrNull(action, paramSyntax);
        if (updateSyntax == null || updateSyntax.equals("")) {
            updateSyntax = "SPARQL";
        }
        if ((language = Syntax.lookup(updateSyntax)) == null) {
            ServletOps.errorBadRequest("Unknown syntax: " + updateSyntax);
            return null;
        }
        obj.key(jInput).value(updateString);
        UpdateRequest request = null;
        try {
            request = UpdateFactory.create(updateString, "http://example/base/", language);
        }
        catch (QueryParseException ex) {
            obj.key("errors");
            obj.startArray();
            obj.startObject();
            obj.key("parse-error").value(ex.getMessage());
            obj.key("parse-error-line").value(ex.getLine());
            obj.key("parse-error-column").value(ex.getColumn());
            obj.finishObject();
            obj.finishArray();
            obj.finishObject();
            return obj.build().getAsObject();
        }
        this.formatted(obj, request);
        obj.finishObject();
        return obj.build().getAsObject();
    }

    private void formatted(JsonBuilder obj, UpdateRequest updateRequest) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        updateRequest.output(out);
        obj.key(jFormatted).value(out.asString());
    }

    @Override
    protected String validatorName() {
        return "SPARQL Update";
    }
}

