/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.validation.ValidationAction;
import org.apache.jena.fuseki.validation.ValidatorBaseJson;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class DataValidator
extends ValidatorBaseJson {
    static final String jInput = "input";
    static final String paramFormat = "outputFormat";
    static final String paramIndirection = "url";
    static final String paramData = "data";
    static final String paramSyntax = "languageSyntax";

    @Override
    protected JsonObject execute(ValidationAction action) {
        Lang language;
        JsonBuilder obj = new JsonBuilder();
        obj.startObject();
        String syntax = DataValidator.getArgOrNull(action, paramSyntax);
        if (syntax == null || syntax.equals("")) {
            syntax = RDFLanguages.NQUADS.getName();
        }
        if ((language = RDFLanguages.shortnameToLang(syntax)) == null) {
            ServletOps.errorBadRequest("Unknown syntax: " + syntax);
            return null;
        }
        String string = DataValidator.getArg(action, paramData);
        StringReader sr = new StringReader(string);
        obj.key(jInput).value(string);
        StreamRDF dest = StreamRDFLib.sinkNull();
        try {
            RDFDataMgr.parse(dest, sr, null, language);
        }
        catch (RiotParseException ex) {
            obj.key("errors");
            obj.startArray();
            obj.startObject();
            obj.key("parse-error").value(ex.getMessage());
            obj.key("parse-error-line").value(ex.getLine());
            obj.key("parse-error-column").value(ex.getCol());
            obj.finishObject();
            obj.finishArray();
            obj.finishObject();
            return obj.build().getAsObject();
        }
        catch (RiotException ex) {
            obj.key("errors");
            obj.startArray();
            obj.startObject();
            obj.key("parse-error").value(ex.getMessage());
            obj.finishObject();
            obj.finishArray();
            obj.finishObject();
            return obj.build().getAsObject();
        }
        obj.finishObject();
        return obj.build().getAsObject();
    }

    @Override
    protected String validatorName() {
        return "RDF Data";
    }

    private static class ErrorHandlerMsg
    implements ErrorHandler {
        private List<String> messages = new ArrayList<String>();

        ErrorHandlerMsg(List<String> messages) {
            this.messages = messages;
        }

        @Override
        public void warning(String message, long line, long col) {
            this.output(message, line, col, "Warning", "warning");
        }

        @Override
        public void error(String message, long line, long col) {
            this.output(message, line, col, "Error", "error");
        }

        @Override
        public void fatal(String message, long line, long col) {
            this.output(message, line, col, "Fatal", "error");
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }

        private void output(String message, long line, long col, String typeName, String className) {
            String str2 = SysRIOT.fmtMessage(message, line, col);
            this.messages.add(str2);
        }
    }
}

