/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryCancelledException;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ResponseModel;
import org.apache.jena.fuseki.servlets.ResponseResultSet;
import org.apache.jena.fuseki.servlets.SPARQL_Protocol;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.web.HttpOp;

public abstract class SPARQL_Query
extends SPARQL_Protocol {
    private static final String QueryParseBase = "http://server/unset-base/";
    protected static List<String> allParams = Arrays.asList("query", "default-graph-uri", "named-graph-uri", "query-ref", "stylesheet", "accept", "output", "format", "callback", "force-accept", "timeout");

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        SPARQL_Query.setCommonHeadersForOptions(response);
        response.setHeader("Allow", "GET,OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    @Override
    protected final void perform(HttpAction action) {
        if (action.request.getMethod().equals("GET")) {
            this.executeWithParameter(action);
            return;
        }
        ContentType ct = FusekiLib.getContentType(action);
        if (ct == null || WebContent.isHtmlForm(ct)) {
            this.executeWithParameter(action);
            return;
        }
        if (WebContent.matchContentType(ct, WebContent.ctSPARQLQuery)) {
            this.executeBody(action);
            return;
        }
        ServletOps.error(415, "Bad content type: " + ct.getContentType());
    }

    @Override
    protected void validate(HttpAction action) {
        String method = action.request.getMethod().toUpperCase(Locale.ROOT);
        if (!"POST".equals(method) && !"GET".equals(method)) {
            ServletOps.errorMethodNotAllowed("Not a GET or POST request");
        }
        if ("GET".equals(method) && action.request.getQueryString() == null) {
            ServletOps.warning(action, "Service Description / SPARQL Query / " + action.request.getRequestURI());
            ServletOps.errorNotFound("Service Description: " + action.request.getRequestURI());
        }
        this.validateParams(action, allParams);
        this.validateRequest(action);
    }

    protected abstract void validateRequest(HttpAction var1);

    protected void validateParams(HttpAction action, Collection<String> params) {
        HttpServletRequest request = action.request;
        ContentType ct = FusekiLib.getContentType(request);
        boolean mustHaveQueryParam = true;
        if (ct != null) {
            String incoming = ct.getContentType();
            if (WebContent.matchContentType(WebContent.ctSPARQLQuery, ct)) {
                mustHaveQueryParam = false;
            } else if (!WebContent.matchContentType(WebContent.ctHTMLForm, ct)) {
                ServletOps.error(415, "Unsupported: " + incoming);
            }
        }
        if (mustHaveQueryParam) {
            String queryStr;
            int N = SPARQL_Query.countParamOccurences(request, "query");
            if (N == 0) {
                ServletOps.errorBadRequest("SPARQL Query: No 'query=' parameter");
            }
            if (N > 1) {
                ServletOps.errorBadRequest("SPARQL Query: Multiple 'query=' parameters");
            }
            if ((queryStr = request.getParameter("query")) == null) {
                ServletOps.errorBadRequest("SPARQL Query: No query specified (no 'query=' found)");
            }
            if (queryStr.isEmpty()) {
                ServletOps.errorBadRequest("SPARQL Query: Empty query string");
            }
        }
        if (params != null) {
            Enumeration<String> en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String name = en.nextElement();
                if (params.contains(name)) continue;
                ServletOps.warning(action, "SPARQL Query: Unrecognize request parameter (ignored): " + name);
            }
        }
    }

    private void executeWithParameter(HttpAction action) {
        String queryString = action.request.getParameter("query");
        this.execute(queryString, action);
    }

    private void executeBody(HttpAction action) {
        String queryString = null;
        try {
            ServletInputStream input = action.request.getInputStream();
            queryString = IO.readWholeFileAsUTF8(input);
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
        this.execute(queryString, action);
    }

    private void execute(String queryString, HttpAction action) {
        String queryStringLog = ServletOps.formatForLog(queryString);
        if (action.verbose) {
            action.log.info(String.format("[%d] Query = \n%s", action.id, queryString));
        } else {
            action.log.info(String.format("[%d] Query = %s", action.id, queryStringLog));
        }
        Query query2 = null;
        try {
            query2 = QueryFactory.create(queryString, QueryParseBase, Syntax.syntaxARQ);
            queryStringLog = this.formatForLog(query2);
            this.validateQuery(action, query2);
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (QueryParseException ex) {
            ServletOps.errorBadRequest("Parse error: \n" + queryString + "\n\r" + SPARQL_Query.messageForQPE(ex));
        }
        catch (QueryException ex) {
            ServletOps.errorBadRequest("Error: \n" + queryString + "\n\r" + ex.getMessage());
        }
        try {
            action.beginRead();
            Dataset dataset = this.decideDataset(action, query2, queryStringLog);
            try (QueryExecution qExec = this.createQueryExecution(query2, dataset);){
                SPARQLResult result = this.executeQuery(action, qExec, query2, queryStringLog);
                this.sendResults(action, result, query2.getPrologue());
            }
        }
        catch (QueryCancelledException ex) {
            SPARQL_Query.incCounter(action.getEndpoint().getCounters(), CounterName.QueryTimeouts);
            throw ex;
        }
        finally {
            action.endRead();
        }
    }

    protected abstract void validateQuery(HttpAction var1, Query var2);

    protected QueryExecution createQueryExecution(Query query2, Dataset dataset) {
        return QueryExecutionFactory.create(query2, dataset);
    }

    protected SPARQLResult executeQuery(HttpAction action, QueryExecution queryExecution, Query query2, String queryStringLog) {
        this.setAnyTimeouts(queryExecution, action);
        if (query2.isSelectType()) {
            ResultSet rs = queryExecution.execSelect();
            rs.hasNext();
            action.log.info(String.format("[%d] exec/select", action.id));
            return new SPARQLResult(rs);
        }
        if (query2.isConstructType()) {
            Model model = queryExecution.execConstruct();
            action.log.info(String.format("[%d] exec/construct", action.id));
            return new SPARQLResult(model);
        }
        if (query2.isDescribeType()) {
            Model model = queryExecution.execDescribe();
            action.log.info(String.format("[%d] exec/describe", action.id));
            return new SPARQLResult(model);
        }
        if (query2.isAskType()) {
            boolean b = queryExecution.execAsk();
            action.log.info(String.format("[%d] exec/ask", action.id));
            return new SPARQLResult(b);
        }
        ServletOps.errorBadRequest("Unknown query type - " + queryStringLog);
        return null;
    }

    private void setAnyTimeouts(QueryExecution qexec, HttpAction action) {
        long desiredTimeout = Long.MAX_VALUE;
        String timeoutHeader = action.request.getHeader("Timeout");
        String timeoutParameter = action.request.getParameter("timeout");
        if (timeoutHeader != null) {
            try {
                desiredTimeout = (int)(Float.parseFloat(timeoutHeader) * 1000.0f);
            }
            catch (NumberFormatException e2) {
                throw new FusekiException("Timeout header must be a number", e2);
            }
        }
        if (timeoutParameter != null) {
            try {
                desiredTimeout = (int)(Float.parseFloat(timeoutParameter) * 1000.0f);
            }
            catch (NumberFormatException e3) {
                throw new FusekiException("timeout parameter must be a number", e3);
            }
        }
        if (desiredTimeout != Long.MAX_VALUE) {
            qexec.setTimeout(desiredTimeout);
        }
    }

    protected abstract Dataset decideDataset(HttpAction var1, Query var2, String var3);

    protected void sendResults(HttpAction action, SPARQLResult result, Prologue qPrologue) {
        if (result.isResultSet()) {
            ResponseResultSet.doResponseResultSet(action, result.getResultSet(), qPrologue);
        } else if (result.isGraph()) {
            ResponseModel.doResponseModel(action, result.getModel());
        } else if (result.isBoolean()) {
            ResponseResultSet.doResponseResultSet(action, result.getBooleanResult());
        } else {
            ServletOps.errorOccurred("Unknown or invalid result type");
        }
    }

    private String formatForLog(Query query2) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        out.setFlatMode(true);
        query2.serialize(out);
        return out.asString();
    }

    private String getRemoteString(String queryURI) {
        return HttpOp.execHttpGetString(queryURI);
    }
}

