/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.fuseki.servlets.ActionREST;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_Protocol;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.riot.system.IRIResolver;

public abstract class SPARQL_GSP
extends ActionREST {
    protected static final Target determineTarget(HttpAction action) {
        if (action.getActiveDSG() == null) {
            ServletOps.errorOccurred("Internal error : No action graph (not in a transaction?)");
        }
        boolean dftGraph = SPARQL_GSP.getOneOnly(action.request, "default") != null;
        String uri = SPARQL_GSP.getOneOnly(action.request, "graph");
        if (!dftGraph && uri == null) {
            ServletOps.errorBadRequest("Neither default graph nor named graph specified; no direct name");
            uri = action.request.getRequestURL().toString();
            if (action.request.getRequestURI().equals(action.getDatasetName())) {
                ServletOps.errorBadRequest("Neither default graph nor named graph specified; no direct name");
            }
        }
        String dsTarget = action.getDatasetName();
        if (dftGraph) {
            return Target.createDefault(action.getActiveDSG());
        }
        if (uri.equals("default")) {
            return Target.createDefault(action.getActiveDSG());
        }
        String base = action.request.getRequestURL().toString();
        if (action.request.getQueryString() != null && !base.endsWith("/")) {
            base = base + "/";
        }
        String absUri = IRIResolver.resolveString(uri, base);
        Node gn = NodeFactory.createURI(absUri);
        return Target.createNamed(action.getActiveDSG(), absUri, gn);
    }

    @Override
    protected void validate(HttpAction action) {
        HttpServletRequest request = action.request;
        if (request.getQueryString() == null) {
            return;
        }
        String g = request.getParameter("graph");
        String d = request.getParameter("default");
        if (g != null && d != null) {
            ServletOps.errorBadRequest("Both ?default and ?graph in the query string of the request");
        }
        if (g == null && d == null) {
            ServletOps.errorBadRequest("Neither ?default nor ?graph in the query string of the request");
        }
        int x1 = SPARQL_Protocol.countParamOccurences(request, "graph");
        int x2 = SPARQL_Protocol.countParamOccurences(request, "default");
        if (x1 > 1) {
            ServletOps.errorBadRequest("Multiple ?default in the query string of the request");
        }
        if (x2 > 1) {
            ServletOps.errorBadRequest("Multiple ?graph in the query string of the request");
        }
        Enumeration<String> en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String h = en.nextElement();
            if (!"graph".equals(h) && !"default".equals(h)) {
                ServletOps.errorBadRequest("Unknown parameter '" + h + "'");
            }
            if (request.getParameterValues(h).length == 1) continue;
            ServletOps.errorBadRequest("Multiple parameters '" + h + "'");
        }
    }

    protected static String getOneOnly(HttpServletRequest request, String name) {
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        if (values.length > 1) {
            ServletOps.errorBadRequest("Multiple occurrences of '" + name + "'");
        }
        return values[0];
    }

    protected static final class Target {
        final boolean isDefault;
        final DatasetGraph dsg;
        private Graph _graph;
        final String name;
        final Node graphName;

        static Target createNamed(DatasetGraph dsg, String name, Node graphName) {
            return new Target(false, dsg, name, graphName);
        }

        static Target createDefault(DatasetGraph dsg) {
            return new Target(true, dsg, null, null);
        }

        static Target retarget(Target target, DatasetGraph dsg) {
            Target target2 = new Target(target, dsg);
            target2._graph = null;
            return target2;
        }

        private Target(boolean isDefault, DatasetGraph dsg, String name, Node graphName) {
            this.isDefault = isDefault;
            this.dsg = dsg;
            this._graph = null;
            this.name = name;
            this.graphName = graphName;
            if (isDefault) {
                if (name != null || graphName != null) {
                    throw new IllegalArgumentException("Inconsistent: default and a graph name/node");
                }
            } else if (name == null || graphName == null) {
                throw new IllegalArgumentException("Inconsistent: not default and/or no graph name/node");
            }
        }

        private Target(Target other, DatasetGraph dsg) {
            this.isDefault = other.isDefault;
            this.dsg = dsg;
            this._graph = other._graph;
            this.name = other.name;
            this.graphName = other.graphName;
        }

        public Graph graph() {
            if (!this.isGraphSet()) {
                this._graph = this.isDefault ? this.dsg.getDefaultGraph() : this.dsg.getGraph(this.graphName);
            }
            return this._graph;
        }

        public boolean exists() {
            if (this.isDefault) {
                return true;
            }
            return this.dsg.containsGraph(this.graphName);
        }

        public boolean isGraphSet() {
            return this._graph != null;
        }

        public String toString() {
            if (this.isDefault) {
                return "default";
            }
            return this.name;
        }
    }
}

