/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import javax.servlet.http.HttpServletRequest;
import org.apache.jena.atlas.web.AcceptList;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.servlets.HttpAction;

public class ActionLib {
    public static String mapRequestToDataset(HttpAction action) {
        String uri = action.getActionURI();
        return ActionLib.mapActionRequestToDataset(uri);
    }

    public static String mapActionRequestToDataset(String uri) {
        int i = uri.lastIndexOf(47);
        if (i == -1) {
            return null;
        }
        if (i == 0) {
            return uri;
        }
        return uri.substring(0, i);
    }

    public static String mapRequestToOperation(HttpAction action, DataAccessPoint dsRef) {
        if (dsRef == null) {
            return "";
        }
        String uri = action.getActionURI();
        String name = dsRef.getName();
        if (name.length() >= uri.length()) {
            return "";
        }
        return uri.substring(name.length() + 1);
    }

    public static String mapRequestToDatasetLongest$(String uri) {
        if (uri == null) {
            return null;
        }
        String ds = null;
        for (String ds2 : DataAccessPointRegistry.get().keys()) {
            if (!uri.startsWith(ds2)) continue;
            if (ds == null) {
                ds = ds2;
                continue;
            }
            if (ds.length() >= ds2.length()) continue;
            ds = ds2;
        }
        return ds;
    }

    public static String wholeRequestURL(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null) {
            sb.append("?");
            sb.append(queryString);
        }
        return sb.toString();
    }

    public static String removeContextPath(HttpAction action) {
        return ActionLib.actionURI(action.request);
    }

    public static String actionURI(HttpServletRequest request) {
        String contextPath = request.getServletContext().getContextPath();
        String uri = request.getRequestURI();
        if (contextPath == null) {
            return uri;
        }
        if (contextPath.isEmpty()) {
            return uri;
        }
        String x = uri;
        if (uri.startsWith(contextPath)) {
            x = uri.substring(contextPath.length());
        }
        return x;
    }

    public static MediaType contentNegotation(HttpAction action, AcceptList myPrefs, MediaType defaultMediaType) {
        MediaType mt = ConNeg.chooseContentType(action.request, myPrefs, defaultMediaType);
        if (mt == null) {
            return null;
        }
        if (mt.getContentType() != null) {
            action.response.setContentType(mt.getContentType());
        }
        if (mt.getCharset() != null) {
            action.response.setCharacterEncoding(mt.getCharset());
        }
        return mt;
    }

    public static MediaType contentNegotationRDF(HttpAction action) {
        return ActionLib.contentNegotation(action, DEF.rdfOffer, DEF.acceptRDFXML);
    }

    public static MediaType contentNegotationQuads(HttpAction action) {
        return ActionLib.contentNegotation(action, DEF.quadsOffer, DEF.acceptNQuads);
    }
}

