/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.tdb.StoreConnection;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.base.block.FileMode;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.setup.StoreParams;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTransaction;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.FusekiServer;

public class SystemState {
    private static String SystemDatabaseLocation;
    public static Location location;
    private static Dataset dataset;
    private static DatasetGraphTransaction dsg;
    private static boolean initialized;
    private static final StoreParams systemDatabaseParams;
    public static String PREFIXES;

    public static Dataset getDataset() {
        SystemState.init();
        return dataset;
    }

    public static DatasetGraphTransaction getDatasetGraph() {
        SystemState.init();
        return dsg;
    }

    private static void init() {
        SystemState.init$();
    }

    public static void init$() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (location == null) {
            location = Location.create(FusekiServer.dirSystemDatabase.toString());
        }
        if (!location.isMem()) {
            FileOps.ensureDir(location.getDirectoryPath());
        }
        if (StoreConnection.getExisting(location) != null) {
            Fuseki.serverLog.warn("System database already in the StoreConnection cache");
        }
        StoreConnection.make(location, systemDatabaseParams);
        dataset = TDBFactory.createDataset(location);
        dsg = (DatasetGraphTransaction)dataset.asDatasetGraph();
        dsg.getContext().set(TDB.symUnionDefaultGraph, false);
    }

    static {
        dataset = null;
        dsg = null;
        initialized = false;
        systemDatabaseParams = StoreParams.builder().fileMode(FileMode.direct).blockReadCacheSize(20).blockWriteCacheSize(20).node2NodeIdCacheSize(5000).nodeId2NodeCacheSize(5000).nodeMissCacheSize(100).build();
        PREFIXES = StrUtils.strjoinNL("BASE <http://example/base#>", "PREFIX ja:      <http://jena.hpl.hp.com/2005/11/Assembler#>", "PREFIX fu:      <http://jena.apache.org/fuseki#>", "PREFIX fuseki:  <http://jena.apache.org/fuseki#>", "PREFIX rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "PREFIX rdfs:    <http://www.w3.org/2000/01/rdf-schema#>", "PREFIX tdb:     <http://jena.hpl.hp.com/2008/tdb#>", "PREFIX sdb:     <http://jena.hpl.hp.com/20087/sdb#>", "PREFIX list:    <http://jena.hpl.hp.com/ARQ/list#>", "PREFIX xsd:     <http://www.w3.org/2001/XMLSchema#>", "PREFIX apf:     <http://jena.hpl.hp.com/ARQ/property#>", "PREFIX afn:     <http://jena.hpl.hp.com/ARQ/function#>", "");
    }
}

