/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.HttpServletResponseTracker;

public class RequestLog {
    private static DateFormat dateFormatter = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");

    public static String combinedNCSA(HttpAction action) {
        StringBuilder builder = new StringBuilder();
        HttpServletRequest request = action.request;
        HttpServletResponseTracker response = action.response;
        String remote = RequestLog.get(request, "X-Forwarded-For", request.getRemoteAddr());
        builder.append(remote);
        builder.append(" ");
        builder.append("- - ");
        builder.append("[");
        builder.append(dateFormatter.format(new Date()));
        builder.append("] ");
        builder.append("\"");
        builder.append(request.getMethod());
        builder.append(" ");
        builder.append(request.getRequestURI());
        builder.append("\"");
        builder.append(" ");
        builder.append(response.getStatus());
        builder.append(" ");
        String size = RequestLog.get(response, "Content-Length", "-");
        builder.append(size);
        builder.append(" \"");
        builder.append(RequestLog.get(request, "Referer", ""));
        builder.append("\"");
        builder.append(" \"");
        builder.append(RequestLog.get(request, "User-Agent", ""));
        builder.append("\"");
        return builder.toString();
    }

    private static String get(HttpServletRequest request, String name, String dft) {
        String x = RequestLog.get(request, name);
        if (x == null) {
            x = dft;
        }
        return x;
    }

    private static String get(HttpServletRequest request, String name) {
        Enumeration<String> en = request.getHeaders(name);
        if (!en.hasMoreElements()) {
            return null;
        }
        String x = en.nextElement();
        if (en.hasMoreElements()) {
            Log.warn(RequestLog.class, "Multiple request header values");
        }
        return x;
    }

    private static String get(HttpServletResponse response, String name, String dft) {
        String x = RequestLog.get(response, name);
        if (x == null) {
            x = dft;
        }
        return x;
    }

    private static String get(HttpServletResponse response, String name) {
        Collection<String> en = response.getHeaders(name);
        if (en.isEmpty()) {
            return null;
        }
        if (en.size() != 1) {
            Log.warn(RequestLog.class, "Multiple response header values");
        }
        return response.getHeader(name);
    }

    static {
        dateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

