/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.FusekiEnv;
import org.apache.jena.fuseki.server.FusekiServer;
import org.apache.jena.fuseki.server.ServerInitialConfig;

public class FusekiServerListener
implements ServletContextListener {
    public static ServerInitialConfig initialSetup = null;
    private boolean initialized = false;

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        String x = servletContext.getContextPath();
        if (!x.isEmpty()) {
            Fuseki.configLog.info("Context path = " + x);
        }
        this.init();
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
    }

    public synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        try {
            FusekiServer.init();
            if (!FusekiServer.serverInitialized) {
                Fuseki.serverLog.error("Failed to initialize : Server not running");
                return;
            }
            if (initialSetup == null) {
                String cfg;
                initialSetup = new ServerInitialConfig();
                FusekiServerListener.initialSetup.fusekiConfigFile = cfg = FusekiEnv.FUSEKI_BASE.resolve("config.ttl").toAbsolutePath().toString();
            }
            if (initialSetup != null) {
                FusekiServer.initializeDataAccessPoints(initialSetup, FusekiServer.dirConfiguration.toString());
            } else {
                Fuseki.serverLog.error("No configuration");
                System.exit(0);
            }
        }
        catch (Throwable th) {
            Fuseki.serverLog.error("Exception in initialization: {}", (Object)th.getMessage());
            throw th;
        }
    }
}

