/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraphReadOnly;
import com.hp.hpl.jena.tdb.StoreConnection;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTransaction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.atlas.lib.MultiMap;
import org.apache.jena.atlas.lib.MultiMapToList;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.build.DataServiceDesc;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.CounterSet;
import org.apache.jena.fuseki.server.DatasetStatus;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.OperationName;

public class DataService {
    public static DataService dummy = new DataService(null, null);
    private final DataServiceDesc svcDesc;
    private DatasetGraph dataset = null;
    private MultiMapToList<OperationName, Endpoint> operations = MultiMap.createMapList();
    private Map<String, Endpoint> endpoints = new HashMap<String, Endpoint>();
    private volatile DatasetStatus state = DatasetStatus.UNINITIALIZED;
    private final CounterSet counters = new CounterSet();
    private final AtomicLong requestCounter = new AtomicLong(0L);
    private final AtomicBoolean offlineInProgress = new AtomicBoolean(false);
    private final AtomicBoolean acceptingRequests = new AtomicBoolean(true);
    public AtomicLong activeReadTxn = new AtomicLong(0L);
    public AtomicLong activeWriteTxn = new AtomicLong(0L);
    public AtomicLong totalReadTxn = new AtomicLong(0L);
    public AtomicLong totalWriteTxn = new AtomicLong(0L);

    public static DataService serviceOnlyDataService() {
        return dummy;
    }

    public DataService(DataServiceDesc desc, DatasetGraph dataset) {
        this.svcDesc = desc;
        this.dataset = dataset;
        this.counters.add(CounterName.Requests);
        this.counters.add(CounterName.RequestsGood);
        this.counters.add(CounterName.RequestsBad);
    }

    public DatasetGraph getDataset() {
        return this.dataset;
    }

    public void addEndpoint(OperationName operationName, String endpointName) {
        Endpoint endpoint = new Endpoint(operationName, endpointName);
        this.endpoints.put(endpointName, endpoint);
        this.operations.put(operationName, endpoint);
    }

    public Endpoint getOperation(String endpointName) {
        return this.endpoints.get(endpointName);
    }

    public List<Endpoint> getOperation(OperationName opName) {
        List<Endpoint> x = this.operations.get((Object)opName);
        if (x == null) {
            x = Collections.emptyList();
        }
        return x;
    }

    public Collection<OperationName> getOperations() {
        return this.operations.keys();
    }

    public boolean allowUpdate() {
        return true;
    }

    public void goOffline() {
        this.offlineInProgress.set(true);
        this.acceptingRequests.set(false);
        this.state = DatasetStatus.OFFLINE;
    }

    public void goActive() {
        this.offlineInProgress.set(false);
        this.acceptingRequests.set(true);
        this.state = DatasetStatus.ACTIVE;
    }

    public boolean isAcceptingRequests() {
        return this.acceptingRequests.get();
    }

    public CounterSet getCounters() {
        return this.counters;
    }

    public long getRequests() {
        return this.counters.value(CounterName.Requests);
    }

    public long getRequestsGood() {
        return this.counters.value(CounterName.RequestsGood);
    }

    public long getRequestsBad() {
        return this.counters.value(CounterName.RequestsBad);
    }

    public void startTxn(ReadWrite mode) {
        switch (mode) {
            case READ: {
                this.activeReadTxn.getAndIncrement();
                this.totalReadTxn.getAndIncrement();
                break;
            }
            case WRITE: {
                this.activeWriteTxn.getAndIncrement();
                this.totalWriteTxn.getAndIncrement();
            }
        }
    }

    public void finishTxn(ReadWrite mode) {
        switch (mode) {
            case READ: {
                this.activeReadTxn.decrementAndGet();
                break;
            }
            case WRITE: {
                this.activeWriteTxn.decrementAndGet();
            }
        }
        this.checkShutdown();
    }

    private void checkShutdown() {
        if (this.state == DatasetStatus.CLOSING && this.activeReadTxn.get() == 0L && this.activeWriteTxn.get() == 0L) {
            this.shutdown();
        }
    }

    private void shutdown() {
        Fuseki.serverLog.info("Shutting down dataset");
        this.dataset.close();
        if (this.dataset instanceof DatasetGraphTransaction) {
            DatasetGraphTransaction dsgtxn = (DatasetGraphTransaction)this.dataset;
            StoreConnection.release(dsgtxn.getLocation());
        }
        this.dataset = null;
    }

    static {
        DataService.dummy.dataset = new DatasetGraphReadOnly(DatasetGraphFactory.createMemFixed());
        dummy.addEndpoint(OperationName.Query, "query");
        dummy.addEndpoint(OperationName.Query, "sparql");
    }
}

