/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.fuseki.mgt.ActionContainerItem;
import org.apache.jena.fuseki.server.Counter;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.OperationName;
import org.apache.jena.fuseki.servlets.HttpAction;

public class ActionStats
extends ActionContainerItem {
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.doCommon(req, resp);
    }

    @Override
    protected JsonValue execGetContainer(HttpAction action) {
        action.log.info(String.format("[%d] GET stats all", action.id));
        JsonBuilder builder = new JsonBuilder();
        builder.startObject("top");
        builder.key("datasets");
        builder.startObject("datasets");
        for (String ds : DataAccessPointRegistry.get().keys()) {
            this.statsDataset(builder, ds);
        }
        builder.finishObject("datasets");
        builder.finishObject("top");
        return builder.build();
    }

    @Override
    protected JsonValue execGetItem(HttpAction action) {
        action.log.info(String.format("[%d] GET stats dataset %s", action.id, action.getDatasetName()));
        JsonBuilder builder = new JsonBuilder();
        String datasetPath = DataAccessPoint.canonical(action.getDatasetName());
        builder.startObject("TOP");
        builder.key("datasets");
        builder.startObject("datasets");
        this.statsDataset(builder, datasetPath);
        builder.finishObject("datasets");
        builder.finishObject("TOP");
        return builder.build();
    }

    private void statsDataset(JsonBuilder builder, String ds) {
        builder.key(ds);
        DataAccessPoint access = (DataAccessPoint)DataAccessPointRegistry.get().get(ds);
        DataService dSrv = access.getDataService();
        builder.startObject("counters");
        builder.key(CounterName.Requests.name()).value(dSrv.getCounters().value(CounterName.Requests));
        builder.key(CounterName.RequestsGood.name()).value(dSrv.getCounters().value(CounterName.RequestsGood));
        builder.key(CounterName.RequestsBad.name()).value(dSrv.getCounters().value(CounterName.RequestsBad));
        builder.key("endpoints").startObject("endpoints");
        for (OperationName operName : dSrv.getOperations()) {
            List<Endpoint> endpoints = access.getDataService().getOperation(operName);
            for (Endpoint endpoint : endpoints) {
                builder.key(endpoint.getEndpoint());
                builder.startObject();
                this.operationCounters(builder, endpoint);
                builder.key("operation").value(operName.name());
                builder.key("description").value(operName.getDescription());
                builder.finishObject();
            }
        }
        builder.finishObject("endpoints");
        builder.finishObject("counters");
    }

    private void operationCounters(JsonBuilder builder, Endpoint operation) {
        for (CounterName cn : operation.getCounters().counters()) {
            Counter c = operation.getCounters().get(cn);
            builder.key(cn.name()).value(c.value());
        }
    }

    private void statsTxt(HttpServletResponse resp) throws IOException {
        ServletOutputStream out = resp.getOutputStream();
        resp.setContentType("text/plain");
        resp.setCharacterEncoding("utf-8");
        Iterator iter = DataAccessPointRegistry.get().keys().iterator();
        while (iter.hasNext()) {
            String ds = (String)iter.next();
            DataAccessPoint desc = (DataAccessPoint)DataAccessPointRegistry.get().get(ds);
            this.statsTxt(out, desc);
            if (!iter.hasNext()) continue;
            out.println();
        }
        out.flush();
    }

    private void statsTxt(ServletOutputStream out, DataAccessPoint desc) throws IOException {
        DataService dSrv = desc.getDataService();
        out.println("Dataset: " + desc.getName());
        out.println("    Requests      = " + dSrv.getCounters().value(CounterName.Requests));
        out.println("    Good          = " + dSrv.getCounters().value(CounterName.RequestsGood));
        out.println("    Bad           = " + dSrv.getCounters().value(CounterName.RequestsBad));
        out.println("  SPARQL Query:");
        out.println("    Request       = " + this.counter(dSrv, OperationName.Query, CounterName.Requests));
        out.println("    Good          = " + this.counter(dSrv, OperationName.Query, CounterName.RequestsGood));
        out.println("    Bad requests  = " + this.counter(dSrv, OperationName.Query, CounterName.RequestsBad));
        out.println("    Timeouts      = " + this.counter(dSrv, OperationName.Query, CounterName.QueryTimeouts));
        out.println("    Bad exec      = " + this.counter(dSrv, OperationName.Query, CounterName.QueryExecErrors));
        out.println("    IO Errors     = " + this.counter(dSrv, OperationName.Query, CounterName.QueryIOErrors));
        out.println("  SPARQL Update:");
        out.println("    Request       = " + this.counter(dSrv, OperationName.Update, CounterName.Requests));
        out.println("    Good          = " + this.counter(dSrv, OperationName.Update, CounterName.RequestsGood));
        out.println("    Bad requests  = " + this.counter(dSrv, OperationName.Update, CounterName.RequestsBad));
        out.println("    Bad exec      = " + this.counter(dSrv, OperationName.Update, CounterName.UpdateExecErrors));
        out.println("  Upload:");
        out.println("    Requests      = " + this.counter(dSrv, OperationName.Upload, CounterName.Requests));
        out.println("    Good          = " + this.counter(dSrv, OperationName.Upload, CounterName.RequestsGood));
        out.println("    Bad           = " + this.counter(dSrv, OperationName.Upload, CounterName.RequestsBad));
        out.println("  SPARQL Graph Store Protocol:");
        out.println("    GETs          = " + this.gspValue(dSrv, CounterName.HTTPget) + " (good=" + this.gspValue(dSrv, CounterName.HTTPgetGood) + "/bad=" + this.gspValue(dSrv, CounterName.HTTPGetBad) + ")");
        out.println("    PUTs          = " + this.gspValue(dSrv, CounterName.HTTPput) + " (good=" + this.gspValue(dSrv, CounterName.HTTPputGood) + "/bad=" + this.gspValue(dSrv, CounterName.HTTPputBad) + ")");
        out.println("    POSTs         = " + this.gspValue(dSrv, CounterName.HTTPpost) + " (good=" + this.gspValue(dSrv, CounterName.HTTPpostGood) + "/bad=" + this.gspValue(dSrv, CounterName.HTTPpostBad) + ")");
        out.println("    DELETEs       = " + this.gspValue(dSrv, CounterName.HTTPdelete) + " (good=" + this.gspValue(dSrv, CounterName.HTTPdeleteGood) + "/bad=" + this.gspValue(dSrv, CounterName.HTTPdeleteBad) + ")");
        out.println("    HEADs         = " + this.gspValue(dSrv, CounterName.HTTPhead) + " (good=" + this.gspValue(dSrv, CounterName.HTTPheadGood) + "/bad=" + this.gspValue(dSrv, CounterName.HTTPheadBad) + ")");
    }

    private long counter(DataService dSrv, OperationName opName, CounterName cName) {
        return 0L;
    }

    private long gspValue(DataService dSrv, CounterName cn) {
        return this.counter(dSrv, OperationName.GSP, cn) + this.counter(dSrv, OperationName.GSP_R, cn);
    }

    @Override
    protected JsonValue execPostContainer(HttpAction action) {
        throw new InternalError("POST container");
    }

    @Override
    protected JsonValue execPostItem(HttpAction action) {
        throw new InternalError("POST item");
    }
}

