/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.uuid.JenaUUID;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTransaction;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.build.Builder;
import org.apache.jena.fuseki.build.TemplateFunctions;
import org.apache.jena.fuseki.mgt.ActionContainerItem;
import org.apache.jena.fuseki.mgt.JsonDescription;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.FusekiServer;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.server.SystemState;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.ActionSPARQL;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.servlets.Upload;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class ActionDatasets
extends ActionContainerItem {
    private static Dataset system = SystemState.getDataset();
    private static DatasetGraphTransaction systemDSG = SystemState.getDatasetGraph();
    private static Property pServiceName = FusekiVocab.pServiceName;
    private static Property pStatus = FusekiVocab.pStatus;
    private static final String paramDatasetName = "dbName";
    private static final String paramDatasetType = "dbType";
    private static final String tDatabasetTDB = "tdb";
    private static final String tDatabasetMem = "mem";

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doCommon(request, response);
    }

    @Override
    protected JsonValue execGetContainer(HttpAction action) {
        action.log.info(String.format("[%d] GET datasets", action.id));
        JsonBuilder builder = new JsonBuilder();
        builder.startObject("D");
        builder.key("datasets");
        JsonDescription.arrayDatasets(builder, DataAccessPointRegistry.get());
        builder.finishObject("D");
        return builder.build();
    }

    @Override
    protected JsonValue execGetItem(HttpAction action) {
        action.log.info(String.format("[%d] GET dataset %s", action.id, action.getDatasetName()));
        JsonBuilder builder = new JsonBuilder();
        DataAccessPoint dsDesc = (DataAccessPoint)DataAccessPointRegistry.get().get(action.getDatasetName());
        if (dsDesc == null) {
            ServletOps.errorNotFound("Not found: dataset " + action.getDatasetName());
        }
        JsonDescription.describe(builder, dsDesc);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JsonValue execPostContainer(HttpAction action) {
        JenaUUID uuid2 = JenaUUID.generate();
        String newURI = uuid2.asURI();
        Node gn = NodeFactory.createURI(newURI);
        ContentType ct = FusekiLib.getContentType(action);
        boolean committed = false;
        system.begin(ReadWrite.WRITE);
        try {
            Model model = system.getNamedModel(gn.getURI());
            StreamRDF dest = StreamRDFLib.graph(model.getGraph());
            if (WebContent.isHtmlForm(ct)) {
                this.assemblerFromForm(action, dest);
            } else if (WebContent.isMultiPartForm(ct)) {
                this.assemblerFromUpload(action, dest);
            } else {
                this.assemblerFromBody(action, dest);
            }
            String filename = FusekiServer.dirFileArea.resolve(uuid2.asString()).toString();
            try (FileOutputStream outCopy = new FileOutputStream(filename);){
                RDFDataMgr.write((OutputStream)outCopy, model, Lang.TURTLE);
            }
            Statement stmt = ActionDatasets.getOne(model, null, pServiceName, null);
            if (stmt == null) {
                StmtIterator sIter = model.listStatements(null, pServiceName, (RDFNode)null);
                if (!sIter.hasNext()) {
                    ServletOps.errorBadRequest("No name given in description of Fuseki service");
                }
                sIter.next();
                if (sIter.hasNext()) {
                    ServletOps.errorBadRequest("Multiple names given in description of Fuseki service");
                }
                throw new InternalErrorException("Inconsistent: getOne didn't fail the second time");
            }
            if (!stmt.getObject().isLiteral()) {
                ServletOps.errorBadRequest("Found " + FmtUtils.stringForRDFNode(stmt.getObject()) + " : Service names are strings, then used to build the external URI");
            }
            Resource subject = stmt.getSubject();
            Literal object = stmt.getObject().asLiteral();
            if (object.getDatatype() != null && !object.getDatatype().equals(XSDDatatype.XSDstring)) {
                action.log.warn(String.format("[%d] Service name '%s' is not a string", action.id, FmtUtils.stringForRDFNode(object)));
            }
            String datasetName = object.getLexicalForm();
            String datasetPath = DataAccessPoint.canonical(datasetName);
            action.log.info(String.format("[%d] Create database : name = %s", action.id, datasetPath));
            if (DataAccessPointRegistry.get().isRegistered(datasetPath)) {
                ServletOps.error(409, "Name already registered " + datasetPath);
            }
            model.removeAll(null, pStatus, null);
            model.add(subject, pStatus, FusekiVocab.stateActive);
            DataAccessPoint ref = Builder.buildDataAccessPoint(subject);
            DataAccessPointRegistry.register(datasetPath, ref);
            action.getResponse().setContentType("text/plain");
            ServletOutputStream out = action.getResponse().getOutputStream();
            out.println("That went well");
            ServletOps.success(action);
            system.commit();
            committed = true;
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
        finally {
            if (!committed) {
                system.abort();
            }
            system.end();
        }
        return null;
    }

    @Override
    protected JsonValue execPostItem(HttpAction action) {
        String s;
        DataService dSrv;
        String name = action.getDatasetName();
        if (name == null) {
            name = "''";
        }
        action.log.info(String.format("[%d] POST dataset %s", action.id, name));
        if (action.getDataAccessPoint() == null) {
            ServletOps.errorNotFound("Not found: dataset " + action.getDatasetName());
        }
        if ((dSrv = action.getDataService()) == null) {
            dSrv = action.getDataAccessPoint().getDataService();
        }
        if ((s = action.request.getParameter("state")) == null || s.isEmpty()) {
            ServletOps.errorBadRequest("No state change given");
        }
        if (s.equalsIgnoreCase("active")) {
            action.log.info(String.format("[%d] REBUILD DATASET %s", action.id, name));
            this.setDatasetState(name, FusekiVocab.stateActive);
            dSrv.goActive();
        } else if (s.equalsIgnoreCase("offline")) {
            action.log.info(String.format("[%d] OFFLINE DATASET %s", action.id, name));
            DataAccessPoint access = action.getDataAccessPoint();
            dSrv.goOffline();
            this.setDatasetState(name, FusekiVocab.stateOffline);
        } else if (s.equalsIgnoreCase("unlink")) {
            action.log.info(String.format("[%d] UNLINK ACCESS NAME %s", action.id, name));
            DataAccessPoint access = action.getDataAccessPoint();
            ServletOps.errorNotImplemented("unlink: dataset" + action.getDatasetName());
        } else {
            ServletOps.errorBadRequest("State change operation '" + s + "' not recognized");
        }
        return null;
    }

    private void assemblerFromBody(HttpAction action, StreamRDF dest) {
        ActionDatasets.bodyAsGraph(action, dest);
    }

    private void assemblerFromForm(HttpAction action, StreamRDF dest) {
        String dbType = action.getRequest().getParameter(paramDatasetType);
        String dbName = action.getRequest().getParameter(paramDatasetName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("NAME", dbName);
        FusekiServer.addGlobals(params);
        if (dbType == null || dbName == null) {
            ServletOps.errorBadRequest("Required parameters: dbName and dbType");
        }
        if (!dbType.equals(tDatabasetTDB) && !dbType.equals(tDatabasetMem)) {
            ServletOps.errorBadRequest(String.format("dbType can be only '%s' or '%s'", tDatabasetTDB, tDatabasetMem));
        }
        String template = null;
        if (dbType.equalsIgnoreCase(tDatabasetTDB)) {
            template = TemplateFunctions.templateFile("templates/config-tdb", params, Lang.TTL);
        }
        if (dbType.equalsIgnoreCase(tDatabasetMem)) {
            template = TemplateFunctions.templateFile("templates/config-mem", params, Lang.TTL);
        }
        RDFDataMgr.parse(dest, new StringReader(template), "http://base/", Lang.TTL);
    }

    private void assemblerFromUpload(HttpAction action, StreamRDF dest) {
        Upload.fileUploadWorker(action, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execDeleteItem(HttpAction action) {
        String name = action.getDatasetName();
        if (name == null) {
            name = "";
        }
        action.log.info(String.format("[%d] DELETE ds=%s", action.id, name));
        if (!DataAccessPointRegistry.get().isRegistered(name)) {
            ServletOps.errorNotFound("No such dataset registered: " + name);
        }
        systemDSG.begin(ReadWrite.WRITE);
        boolean committed = false;
        try {
            DataAccessPoint ref = (DataAccessPoint)DataAccessPointRegistry.get().get(name);
            if (ref == null) {
                ServletOps.errorNotFound("No such dataset registered: " + name);
            }
            DataAccessPointRegistry.get().remove(name);
            Quad q = ActionDatasets.getOne(systemDSG, null, null, pServiceName.asNode(), null);
            if (q != null) {
                Node gn = q.getGraph();
                systemDSG.deleteAny(gn, null, null, null);
            }
            systemDSG.commit();
            committed = true;
            ServletOps.success(action);
        }
        finally {
            if (!committed) {
                systemDSG.abort();
            }
            systemDSG.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDatasetState(String name, Resource newState) {
        boolean committed = false;
        system.begin(ReadWrite.WRITE);
        try {
            String dbName = name;
            if (dbName.startsWith("/")) {
                dbName = dbName.substring(1);
            }
            String update2 = StrUtils.strjoinNL(SystemState.PREFIXES, "DELETE { GRAPH ?g { ?s fu:status ?state } }", "INSERT { GRAPH ?g { ?s fu:status " + FmtUtils.stringForRDFNode(newState) + " } }", "WHERE {", "   GRAPH ?g { ?s fu:name '" + dbName + "' ; ", "                 fu:status ?state .", "   }", "}");
            UpdateRequest req = UpdateFactory.create(update2);
            UpdateAction.execute(req, system);
            system.commit();
            committed = true;
        }
        finally {
            if (!committed) {
                system.abort();
            }
            system.end();
        }
    }

    private static Quad getOne(DatasetGraph dsg, Node g, Node s, Node p, Node o) {
        Iterator<Quad> iter = dsg.findNG(g, s, p, o);
        if (!iter.hasNext()) {
            return null;
        }
        Quad q = iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return q;
    }

    private static Statement getOne(Model m, Resource s, Property p, RDFNode o) {
        StmtIterator iter = m.listStatements(s, p, o);
        if (!iter.hasNext()) {
            return null;
        }
        Statement stmt = (Statement)iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return stmt;
    }

    private static void bodyAsGraph(HttpAction action, StreamRDF dest) {
        HttpServletRequest request = action.request;
        String base = ActionLib.wholeRequestURL(request);
        ContentType ct = FusekiLib.getContentType(request);
        Lang lang = RDFLanguages.contentTypeToLang(ct.getContentType());
        if (lang == null) {
            ServletOps.errorBadRequest("Unknown content type for triples: " + ct);
            return;
        }
        ServletInputStream input = null;
        try {
            input = request.getInputStream();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
        int len = request.getContentLength();
        dest.prefix("root", base + "#");
        ActionSPARQL.parse(action, dest, input, lang, base);
    }
}

