/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.servlets.ActionBase;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;

public abstract class ActionCtl
extends ActionBase {
    protected ActionCtl() {
        super(Fuseki.adminLog);
    }

    @Override
    protected final void execCommonWorker(HttpAction action) {
        DataAccessPoint dataAccessPoint;
        String datasetUri = this.mapRequestToDatasetName(action);
        if (datasetUri != null) {
            dataAccessPoint = (DataAccessPoint)DataAccessPointRegistry.get().get(datasetUri);
            if (dataAccessPoint == null) {
                ServletOps.errorNotFound("Not found: " + datasetUri);
                return;
            }
        } else {
            dataAccessPoint = null;
            DataService dataService = DataService.serviceOnlyDataService();
        }
        action.setControlRequest(dataAccessPoint, datasetUri);
        action.setEndpoint(null, null);
        this.executeAction(action);
    }

    protected String mapRequestToDatasetName(HttpAction action) {
        return ActionCtl.extractItemName(action);
    }

    protected void executeAction(HttpAction action) {
        this.executeLifecycle(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executeLifecycle(HttpAction action) {
        this.startRequest(action);
        try {
            this.perform(action);
        }
        finally {
            this.finishRequest(action);
        }
    }

    protected final boolean isContainerAction(HttpAction action) {
        return action.getDataAccessPoint() == null;
    }

    protected abstract void perform(HttpAction var1);
}

