/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.jetty;

import com.hp.hpl.jena.sparql.util.Utils;
import java.io.FileInputStream;
import java.net.BindException;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.jetty.FusekiErrorHandler;
import org.apache.jena.fuseki.jetty.JettyServerConfig;
import org.apache.jena.fuseki.mgt.MgtJMX;
import org.apache.jena.fuseki.server.FusekiEnv;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class JettyFuseki {
    public static JettyFuseki instance;
    private ServerConnector serverConnector = null;
    private ServerConnector mgtConnector = null;
    private JettyServerConfig serverConfig;
    private Server server = null;
    public static String contextpath;
    public static final String resourceBase1 = "webapp";
    public static final String resourceBase2 = "src/main/webapp";

    public static void initializeServer(JettyServerConfig config) {
        Fuseki.verboseLogging = config.verboseLogging;
        instance = new JettyFuseki(config);
    }

    private JettyFuseki(JettyServerConfig config) {
        this.serverConfig = config;
        this.buildServerWebapp(this.serverConfig.contextPath, this.serverConfig.jettyConfigFile, config.enableCompression);
        if (this.mgtConnector == null) {
            this.mgtConnector = this.serverConnector;
        }
    }

    public void start() {
        String host;
        String version2 = Fuseki.VERSION;
        String buildDate = Fuseki.BUILD_DATE;
        if (version2 != null && version2.equals("${project.version}")) {
            version2 = null;
        }
        if (buildDate != null && buildDate.equals("${build.time.xsd}")) {
            buildDate = Utils.nowAsXSDDateTimeString();
        }
        if (version2 != null && buildDate != null) {
            Fuseki.serverLog.info(String.format("%s %s %s", "Fuseki", version2, buildDate));
        }
        if ((host = this.serverConnector.getHost()) != null) {
            Fuseki.serverLog.info("Incoming connections limited to " + host);
        }
        try {
            this.server.start();
        }
        catch (BindException ex) {
            Fuseki.serverLog.error("SPARQLServer (port=" + this.serverConnector.getPort() + "): Failed to start server: " + ex.getMessage());
            System.exit(1);
        }
        catch (Exception ex) {
            Fuseki.serverLog.error("SPARQLServer: Failed to start server: " + ex.getMessage(), ex);
            System.exit(1);
        }
        String now2 = Utils.nowAsString();
        Fuseki.serverLog.info(String.format("Started %s on port %d", now2, this.serverConnector.getPort()));
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        String now2 = Utils.nowAsString();
        Fuseki.serverLog.info(String.format("Stopped %s on port %d", now2, this.serverConnector.getPort()));
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            Fuseki.serverLog.warn("SPARQLServer: Exception while stopping server: " + ex.getMessage(), ex);
        }
        MgtJMX.removeJMX();
    }

    public static WebAppContext createWebApp(String contextPath) {
        FusekiEnv.setEnvironment();
        WebAppContext webapp = new WebAppContext();
        webapp.getServletContext().getContextHandler().setMaxFormContentSize(10000000);
        String resourceBase3 = null;
        String resourceBase4 = null;
        if (FusekiEnv.FUSEKI_HOME != null) {
            String HOME = FusekiEnv.FUSEKI_HOME.toString();
            resourceBase3 = HOME + "/" + resourceBase1;
            resourceBase4 = HOME + "/" + resourceBase2;
        }
        String resourceBase = JettyFuseki.tryResourceBase(resourceBase1, null);
        resourceBase = JettyFuseki.tryResourceBase(resourceBase2, resourceBase);
        resourceBase = JettyFuseki.tryResourceBase(resourceBase3, resourceBase);
        if ((resourceBase = JettyFuseki.tryResourceBase(resourceBase4, resourceBase)) == null) {
            if (resourceBase3 == null) {
                Fuseki.serverLog.error("Can't find resourceBase (tried webapp and src/main/webapp)");
            } else {
                Fuseki.serverLog.error("Can't find resourceBase (tried webapp, src/main/webapp, " + resourceBase3 + " and " + resourceBase4 + ")");
            }
            Fuseki.serverLog.error("Failed to start");
            throw new FusekiException("Failed to start");
        }
        webapp.setDescriptor(resourceBase + "/WEB-INF/web.xml");
        webapp.setResourceBase(resourceBase);
        webapp.setContextPath(contextPath);
        webapp.setDisplayName(Fuseki.servletRequestLogName);
        webapp.setParentLoaderPriority(true);
        webapp.setErrorHandler(new FusekiErrorHandler());
        return webapp;
    }

    public static String getenv(String name) {
        String x = System.getenv(name);
        if (x == null) {
            x = System.getProperty(name);
        }
        return x;
    }

    private static String tryResourceBase(String maybeResourceBase, String currentResourceBase) {
        if (currentResourceBase != null) {
            return currentResourceBase;
        }
        if (maybeResourceBase != null && FileOps.exists(maybeResourceBase)) {
            return maybeResourceBase;
        }
        return currentResourceBase;
    }

    private void buildServerWebapp(String contextPath, String jettyConfig, boolean enableCompression) {
        if (jettyConfig != null) {
            this.configServer(jettyConfig);
        } else {
            this.defaultServerConfig(this.serverConfig.port, this.serverConfig.loopback);
        }
        WebAppContext webapp = JettyFuseki.createWebApp(contextPath);
        this.server.setHandler(webapp);
        if (jettyConfig == null && this.serverConfig.authConfigFile != null) {
            JettyFuseki.security(webapp, this.serverConfig.authConfigFile);
        }
    }

    private static void security(ServletContextHandler context, String authfile) {
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"fuseki"});
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setPathSpec("/*");
        DefaultIdentityService identService = new DefaultIdentityService();
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.addConstraintMapping(mapping);
        securityHandler.setIdentityService(identService);
        HashLoginService loginService = new HashLoginService("Fuseki Authentication", authfile);
        loginService.setIdentityService(identService);
        securityHandler.setLoginService(loginService);
        securityHandler.setAuthenticator(new BasicAuthenticator());
        context.setSecurityHandler(securityHandler);
        Fuseki.serverLog.debug("Basic Auth Configuration = " + authfile);
    }

    private void configServer(String jettyConfig) {
        try {
            Fuseki.serverLog.info("Jetty server config file = " + jettyConfig);
            this.server = new Server();
            XmlConfiguration configuration = new XmlConfiguration(new FileInputStream(jettyConfig));
            configuration.configure(this.server);
            this.serverConnector = (ServerConnector)this.server.getConnectors()[0];
        }
        catch (Exception ex) {
            Fuseki.serverLog.error("SPARQLServer: Failed to configure server: " + ex.getMessage(), ex);
            throw new FusekiException("Failed to configure a server using configuration file '" + jettyConfig + "'");
        }
    }

    private void defaultServerConfig(int port, boolean loopback) {
        this.server = new Server();
        HttpConnectionFactory f1 = new HttpConnectionFactory();
        f1.getHttpConfiguration().setRequestHeaderSize(524288);
        f1.getHttpConfiguration().setOutputBufferSize(0x500000);
        ServerConnector connector = new ServerConnector(this.server, f1);
        connector.setPort(port);
        this.server.addConnector(connector);
        if (loopback) {
            connector.setHost("localhost");
        }
        connector.setPort(port);
        this.serverConnector = connector;
    }

    static {
        Fuseki.init();
        instance = null;
        contextpath = "/";
    }
}

