/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.cmd;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdARQ;
import arq.cmdline.ModDatasetAssembler;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.tdb.TDB;
import java.util.List;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiLogging;
import org.apache.jena.fuseki.jetty.JettyFuseki;
import org.apache.jena.fuseki.jetty.JettyServerConfig;
import org.apache.jena.fuseki.server.FusekiEnv;
import org.apache.jena.fuseki.server.FusekiServerListener;
import org.apache.jena.fuseki.server.ServerInitialConfig;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.slf4j.Logger;

public class FusekiCmd {
    public static void main(String ... argv) {
        FusekiCmdInner.innerMain(argv);
    }

    static {
        FusekiEnv.mode = FusekiEnv.INIT.STANDALONE;
        FusekiLogging.setLogging();
    }

    static class FusekiCmdInner
    extends CmdARQ {
        private static ArgDecl argMgt = new ArgDecl(false, "mgt", new String[0]);
        private static ArgDecl argMgtPort = new ArgDecl(true, "mgtPort", "mgtport");
        private static ArgDecl argHome = new ArgDecl(true, "home", new String[0]);
        private static ArgDecl argPages = new ArgDecl(true, "pages", new String[0]);
        private static ArgDecl argMem = new ArgDecl(false, "mem", new String[0]);
        private static ArgDecl argAllowUpdate = new ArgDecl(false, "update", "allowUpdate");
        private static ArgDecl argFile = new ArgDecl(true, "file", new String[0]);
        private static ArgDecl argMemTDB = new ArgDecl(false, "memtdb", "memTDB");
        private static ArgDecl argTDB = new ArgDecl(true, "loc", "location");
        private static ArgDecl argPort = new ArgDecl(true, "port", new String[0]);
        private static ArgDecl argLocalhost = new ArgDecl(false, "localhost", "local");
        private static ArgDecl argTimeout = new ArgDecl(true, "timeout", new String[0]);
        private static ArgDecl argFusekiConfig = new ArgDecl(true, "config", "conf");
        private static ArgDecl argJettyConfig = new ArgDecl(true, "jetty-config", new String[0]);
        private static ArgDecl argGZip = new ArgDecl(true, "gzip", new String[0]);
        private static ArgDecl argBasicAuth = new ArgDecl(true, "basic-auth", new String[0]);
        private static ModDatasetAssembler modDataset = new ModDatasetAssembler();
        private JettyServerConfig jettyServerConfig = new JettyServerConfig();
        private ServerInitialConfig cmdLineDataset;
        static String argUsage = "[--config=FILE] [--mem|--desc=AssemblerFile|--file=FILE] [--port PORT] /DatasetPathName";

        public static void innerMain(String ... argv) {
            ARQ.init();
            TDB.init();
            Fuseki.init();
            new FusekiCmdInner(argv).mainRun();
        }

        public FusekiCmdInner(String ... argv) {
            super(argv);
            this.jettyServerConfig.port = 3030;
            this.jettyServerConfig.contextPath = "/";
            this.jettyServerConfig.jettyConfigFile = null;
            this.jettyServerConfig.pages = Fuseki.PagesStatic;
            this.jettyServerConfig.enableCompression = true;
            this.jettyServerConfig.verboseLogging = false;
            this.cmdLineDataset = new ServerInitialConfig();
            this.getUsage().startCategory("Fuseki");
            this.addModule(modDataset);
            this.add(argMem, "--mem", "Create an in-memory, non-persistent dataset for the server");
            this.add(argFile, "--file=FILE", "Create an in-memory, non-persistent dataset for the server, initialised with the contents of the file");
            this.add(argTDB, "--loc=DIR", "Use an existing TDB database (or create if does not exist)");
            this.add(argMemTDB, "--memTDB", "Create an in-memory, non-persistent dataset using TDB (testing only)");
            this.add(argPort, "--port", "Listen on this port number");
            this.add(argPages, "--pages=DIR", "Set of pages to serve as static content");
            this.add(argLocalhost, "--localhost", "Listen only on the localhost interface");
            this.add(argTimeout, "--timeout=", "Global timeout applied to queries (value in ms) -- format is X[,Y] ");
            this.add(argAllowUpdate, "--update", "Allow updates (via SPARQL Update and SPARQL HTTP Update)");
            this.add(argFusekiConfig, "--config=", "Use a configuration file to determine the services");
            this.add(argJettyConfig, "--jetty-config=FILE", "Set up the server (not services) with a Jetty XML file");
            this.add(argBasicAuth);
            this.add(argMgt);
            this.add(argMgtPort);
            this.add(argGZip, "--gzip=on|off", "Enable GZip compression (HTTP Accept-Encoding) if request header set");
            this.modVersion.addClass(TDB.class);
            this.modVersion.addClass(Fuseki.class);
        }

        @Override
        protected String getSummary() {
            return this.getCommandName() + " " + argUsage;
        }

        @Override
        protected void processModulesAndArgs() {
            int x = 0;
            Logger log = Fuseki.serverLog;
            if (this.contains(argFusekiConfig)) {
                this.cmdLineDataset.fusekiConfigFile = this.getValue(argFusekiConfig);
            }
            ArgDecl assemblerDescDecl = new ArgDecl(true, "desc", "dataset");
            if (this.contains(argMem)) {
                ++x;
            }
            if (this.contains(argFile)) {
                ++x;
            }
            if (this.contains(assemblerDescDecl)) {
                ++x;
            }
            if (this.contains(argTDB)) {
                ++x;
            }
            if (this.contains(argMemTDB)) {
                ++x;
            }
            if (this.cmdLineDataset.fusekiConfigFile != null) {
                if (x >= 1) {
                    throw new CmdException("Dataset specified on the command line but a configuration file also given.");
                }
            } else if (x > 1) {
                throw new CmdException("Multiple ways providing a dataset. Only one of --mem, --file, --loc or --desc");
            }
            if (this.contains(argMem)) {
                log.info("Dataset: in-memory");
                this.cmdLineDataset = new ServerInitialConfig();
                this.cmdLineDataset.templateFile = "templates/config-mem";
            }
            if (this.contains(argFile)) {
                String filename = this.getValue(argFile);
                log.info("Dataset: in-memory: load file: " + filename);
                if (!FileOps.exists(filename)) {
                    throw new CmdException("File not found: " + filename);
                }
                this.cmdLineDataset = new ServerInitialConfig();
                this.cmdLineDataset.dsg = DatasetGraphFactory.createMem();
                Lang language = RDFLanguages.filenameToLang(filename);
                if (language == null) {
                    throw new CmdException("Can't guess language for file: " + filename);
                }
                RDFDataMgr.read(this.cmdLineDataset.dsg, filename);
            }
            if (this.contains(argMemTDB)) {
                this.cmdLineDataset = new ServerInitialConfig();
                this.cmdLineDataset.templateFile = "templates/config-tdb-mem";
                this.cmdLineDataset.params.put("DIR", "--mem--");
            }
            if (this.contains(argTDB)) {
                this.cmdLineDataset = new ServerInitialConfig();
                this.cmdLineDataset.templateFile = "templates/config-tdb-dir";
                String dir = this.getValue(argTDB);
                this.cmdLineDataset.params.put("DIR", dir);
            }
            if (this.contains(assemblerDescDecl)) {
                log.info("Dataset from assembler");
                Dataset ds = modDataset.createDataset();
            }
            if (this.cmdLineDataset != null) {
                if (this.getPositional().size() > 1) {
                    throw new CmdException("Multiple dataset path names given");
                }
                if (this.getPositional().size() != 0) {
                    this.cmdLineDataset.datasetPath = this.getPositionalArg(0);
                    if (this.cmdLineDataset.datasetPath.length() > 0 && !this.cmdLineDataset.datasetPath.startsWith("/")) {
                        throw new CmdException("Dataset path name must begin with a /: " + this.cmdLineDataset.datasetPath);
                    }
                    this.cmdLineDataset.allowUpdate = this.contains(argAllowUpdate);
                    if (!this.cmdLineDataset.allowUpdate) {
                        Fuseki.serverLog.info("Running in read-only mode for " + this.cmdLineDataset.datasetPath);
                    }
                    this.cmdLineDataset.params.put("NAME", this.cmdLineDataset.datasetPath);
                }
            }
            if (this.contains(argBasicAuth)) {
                Fuseki.configLog.warn("--basic-auth ignored: Use Apache Shiro security - see shiro.ini");
            }
            if (this.contains(argPort)) {
                String portStr = this.getValue(argPort);
                try {
                    this.jettyServerConfig.port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException ex) {
                    throw new CmdException(argPort.getKeyName() + " : bad port number: " + portStr);
                }
            }
            if (this.contains(argMgt)) {
                Fuseki.configLog.warn("Fuseki v2: Management functions are always enabled.  --mgt not needed.");
            }
            if (this.contains(argMgtPort)) {
                Fuseki.configLog.warn("Fuseki v2: Management functions are always on the same port as the server.  --mgtPort ignored.");
            }
            if (this.contains(argLocalhost)) {
                this.jettyServerConfig.loopback = true;
            }
            if (this.contains(argTimeout)) {
                String str2 = this.getValue(argTimeout);
                ARQ.getContext().set(ARQ.queryTimeout, str2);
            }
            if (this.contains(argJettyConfig)) {
                this.jettyServerConfig.jettyConfigFile = this.getValue(argJettyConfig);
                if (!FileOps.exists(this.jettyServerConfig.jettyConfigFile)) {
                    throw new CmdException("No such file: " + this.jettyServerConfig.jettyConfigFile);
                }
            }
            if (this.contains(argBasicAuth)) {
                this.jettyServerConfig.authConfigFile = this.getValue(argBasicAuth);
                if (!FileOps.exists(this.jettyServerConfig.authConfigFile)) {
                    throw new CmdException("No such file: " + this.jettyServerConfig.authConfigFile);
                }
            }
            if (this.contains(argHome)) {
                Fuseki.configLog.warn("--home ignored (use enviroment variables $FUSEKI_HOME and $FUSEKI_BASE)");
            }
            if (this.contains(argPages)) {
                List<String> args = super.getValues(argPages);
                this.jettyServerConfig.pages = args.get(args.size() - 1);
            }
            if (this.contains(argGZip)) {
                if (!this.hasValueOfTrue(argGZip) && !this.hasValueOfFalse(argGZip)) {
                    throw new CmdException(argGZip.getNames().get(0) + ": Not understood: " + this.getValue(argGZip));
                }
                this.jettyServerConfig.enableCompression = super.hasValueOfTrue(argGZip);
            }
        }

        private static String sort_out_dir(String path) {
            path.replace('\\', '/');
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            return path;
        }

        @Override
        protected void exec() {
            FusekiServerListener.initialSetup = this.cmdLineDataset;
            JettyFuseki.initializeServer(this.jettyServerConfig);
            JettyFuseki.instance.start();
            JettyFuseki.instance.join();
            System.exit(0);
        }

        @Override
        protected String getCommandName() {
            return "fuseki";
        }
    }
}

