/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.build;

import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.build.Builder;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DatasetStatus;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.server.SystemState;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;

public class FusekiConfig {
    private static Logger log;
    private static FilenameFilter visibleFiles;

    public static List<DataAccessPoint> readConfigFile(String filename) {
        Model model = RDFDataMgr.loadModel(filename);
        if (model.size() == 0L) {
            return Collections.emptyList();
        }
        FusekiConfig.additionalRDF(model);
        FusekiConfig.server(model);
        return FusekiConfig.servicesAndDatasets(model);
    }

    private static void server(Model model) {
        List<Resource> servers = FusekiConfig.getByType(FusekiVocab.tServer, model);
        if (servers.size() == 0) {
            return;
        }
        if (servers.size() > 1) {
            throw new FusekiConfigException(servers.size() + " servers found (must be exactly one in a configuration file)");
        }
        Resource server = servers.get(0);
        FusekiConfig.processServer(server);
    }

    private static void processServer(Resource server) {
        AssemblerUtils.setContext(server, Fuseki.getContext());
        StmtIterator sIter = server.listProperties(JA.loadClass);
        while (sIter.hasNext()) {
            Statement s = sIter.nextStatement();
            RDFNode rn = s.getObject();
            String className = null;
            if (rn instanceof Resource) {
                String uri = ((Resource)rn).getURI();
                if (uri == null) {
                    log.warn("Blank node for class to load");
                    continue;
                }
                String javaScheme = "java:";
                if (!uri.startsWith(javaScheme)) {
                    log.warn("Class to load is not 'java:': " + uri);
                    continue;
                }
                className = uri.substring(javaScheme.length());
            }
            if (rn instanceof Literal) {
                className = ((Literal)rn).getLexicalForm();
            }
            FusekiConfig.loadAndInit(className);
        }
    }

    private static List<DataAccessPoint> servicesAndDatasets(Model model) {
        ResultSet rs = FusekiLib.query("SELECT * { ?s fu:services [ list:member ?member ] }", model);
        ArrayList<DataAccessPoint> accessPoints = new ArrayList<DataAccessPoint>();
        while (rs.hasNext()) {
            QuerySolution soln = rs.next();
            Resource svc = soln.getResource("member");
            DataAccessPoint acc = Builder.buildDataAccessPoint(svc);
            accessPoints.add(acc);
        }
        return accessPoints;
    }

    private static void loadAndInit(String className) {
        try {
            Class<?> classObj = Class.forName(className);
            log.info("Loaded " + className);
            Method initMethod = classObj.getMethod("init", new Class[0]);
            initMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            log.warn("Class not found: " + className);
        }
        catch (Exception e2) {
            throw new FusekiConfigException(e2);
        }
    }

    private static Model additionalRDF(Model m) {
        SystemState.init$();
        String x1 = StrUtils.strjoinNL(SystemState.PREFIXES, "INSERT                    { [] ja:loadClass 'com.hp.hpl.jena.tdb.TDB' }", "WHERE { FILTER NOT EXISTS { [] ja:loadClass 'com.hp.hpl.jena.tdb.TDB' } }");
        String x2 = StrUtils.strjoinNL(SystemState.PREFIXES, "INSERT DATA {", "   tdb:DatasetTDB  rdfs:subClassOf  ja:RDFDataset .", "   tdb:GraphTDB    rdfs:subClassOf  ja:Model .", "}");
        FusekiConfig.execute(m, x1);
        FusekiConfig.execute(m, x2);
        return m;
    }

    private static void execute(Model m, String x) {
        UpdateRequest req = UpdateFactory.create(x);
        UpdateAction.execute(req, m);
    }

    private static List<Resource> getByType(Resource type, Model m) {
        ResIterator rIter = m.listSubjectsWithProperty(RDF.type, type);
        return Iter.toList(rIter);
    }

    public static List<DataAccessPoint> readConfigurationDirectory(String dir) {
        ArrayList<DataAccessPoint> dataServiceRef = new ArrayList<DataAccessPoint>();
        File d = new File(dir);
        String[] aFiles = d.list(visibleFiles);
        if (aFiles == null) {
            log.warn("Not found: directory for assembler files for services: '" + dir + "'");
            return Collections.emptyList();
        }
        for (String assemFile : aFiles) {
            Model m = RDFDataMgr.loadModel(assemFile);
            DataAccessPoint acc = FusekiConfig.readConfiguration(m);
            dataServiceRef.add(acc);
        }
        return dataServiceRef;
    }

    private static DataAccessPoint readConfiguration(Model m) {
        FusekiConfig.additionalRDF(m);
        List<Resource> services = FusekiConfig.getByType(FusekiVocab.fusekiService, m);
        if (services.size() == 0) {
            log.error("No services found");
            throw new FusekiConfigException();
        }
        if (services.size() > 1) {
            log.error("Multiple services found");
            throw new FusekiConfigException();
        }
        Resource service = services.get(0);
        DataAccessPoint acc = Builder.buildDataAccessPoint(service);
        return acc;
    }

    public static List<DataAccessPoint> readSystemDatabase(Dataset ds) {
        String qs = StrUtils.strjoinNL(SystemState.PREFIXES, "SELECT * {", "  GRAPH ?g {", "     ?s fu:name ?name ;", "        fu:status ?status .", "  }", "}");
        ArrayList<DataAccessPoint> refs = new ArrayList<DataAccessPoint>();
        ResultSet rs = FusekiLib.query(qs, ds);
        while (rs.hasNext()) {
            QuerySolution row = rs.next();
            Resource s = row.getResource("s");
            Resource g = row.getResource("g");
            Resource rStatus = row.getResource("status");
            DatasetStatus status = DatasetStatus.status(rStatus);
            Model m = ds.getNamedModel(g.getURI());
            Resource svc = m.wrapAsResource(s.asNode());
            DataAccessPoint ref = Builder.buildDataAccessPoint(svc);
            refs.add(ref);
        }
        return refs;
    }

    static {
        Fuseki.init();
        log = Fuseki.configLog;
        visibleFiles = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.startsWith(".")) {
                    return false;
                }
                File f = new File(dir, name);
                return f.isFile();
            }
        };
    }
}

