/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.build;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.vocabulary.RDF;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.OperationName;
import org.slf4j.Logger;

public class Builder {
    private static Logger log = Fuseki.builderLog;

    public static DataAccessPoint buildDataAccessPoint(Resource svc) {
        RDFNode n = FusekiLib.getOne(svc, "fu:name");
        if (!n.isLiteral()) {
            throw new FusekiConfigException("Not a literal for access point name: " + FmtUtils.stringForRDFNode(n));
        }
        Literal object = n.asLiteral();
        if (object.getDatatype() != null && !object.getDatatype().equals(XSDDatatype.XSDstring)) {
            Fuseki.configLog.error(String.format("Service name '%s' is not a string", FmtUtils.stringForRDFNode(object)));
        }
        String name = object.getLexicalForm();
        name = DataAccessPoint.canonical(name);
        DataService dataService = Builder.buildDataService(svc);
        DataAccessPoint dataAccess = new DataAccessPoint(name);
        dataAccess.setDataService(dataService);
        return dataAccess;
    }

    public static DataService buildDataService(Resource svc) {
        log.info("Service: " + FusekiLib.nodeLabel(svc));
        Resource datasetDesc = (Resource)Builder.getOne(svc, "fu:dataset");
        if (!datasetDesc.hasProperty(RDF.type)) {
            throw new FusekiConfigException("No rdf:type for dataset " + FusekiLib.nodeLabel(datasetDesc));
        }
        Dataset ds = (Dataset)Assembler.general.open(datasetDesc);
        TDB.sync(ds);
        DataService dataService = new DataService(null, ds.asDatasetGraph());
        Builder.addServiceEP(dataService, OperationName.Query, svc, "fu:serviceQuery");
        Builder.addServiceEP(dataService, OperationName.Update, svc, "fu:serviceUpdate");
        Builder.addServiceEP(dataService, OperationName.Upload, svc, "fu:serviceUpload");
        Builder.addServiceEP(dataService, OperationName.GSP_R, svc, "fu:serviceReadGraphStore");
        Builder.addServiceEP(dataService, OperationName.GSP, svc, "fu:serviceReadWriteGraphStore");
        if (!dataService.getOperation(OperationName.GSP).isEmpty()) {
            dataService.addEndpoint(OperationName.Quads, "");
        } else if (!dataService.getOperation(OperationName.GSP_R).isEmpty()) {
            dataService.addEndpoint(OperationName.Quads, "");
        }
        return dataService;
    }

    public static DataService buildDataService(DatasetGraph dsg, boolean allowUpdate) {
        DataService dataService = new DataService(null, dsg);
        Builder.addServiceEP(dataService, OperationName.Query, "query");
        Builder.addServiceEP(dataService, OperationName.Query, "sparql");
        if (!allowUpdate) {
            Builder.addServiceEP(dataService, OperationName.Quads, "quads");
            Builder.addServiceEP(dataService, OperationName.GSP_R, "data");
            return dataService;
        }
        Builder.addServiceEP(dataService, OperationName.GSP, "data");
        Builder.addServiceEP(dataService, OperationName.Update, "update");
        Builder.addServiceEP(dataService, OperationName.Upload, "upload");
        Builder.addServiceEP(dataService, OperationName.Quads, "");
        return dataService;
    }

    private static void addServiceEP(DataService dataService, OperationName opName, String epName) {
        dataService.addEndpoint(opName, epName);
    }

    public static RDFNode getOne(Resource svc, String property) {
        String ln = property.substring(property.indexOf(58) + 1);
        ResultSet rs = FusekiLib.query("SELECT * { ?svc " + property + " ?x}", svc.getModel(), "svc", (RDFNode)svc);
        if (!rs.hasNext()) {
            throw new FusekiConfigException("No " + ln + " for service " + FusekiLib.nodeLabel(svc));
        }
        RDFNode x = rs.next().get("x");
        if (rs.hasNext()) {
            throw new FusekiConfigException("Multiple " + ln + " for service " + FusekiLib.nodeLabel(svc));
        }
        return x;
    }

    private static void addServiceEP(DataService dataService, OperationName opName, Resource svc, String property) {
        ResultSet rs = FusekiLib.query("SELECT * { ?svc " + property + " ?ep}", svc.getModel(), "svc", (RDFNode)svc);
        while (rs.hasNext()) {
            QuerySolution soln = rs.next();
            String epName = soln.getLiteral("ep").getLexicalForm();
            Endpoint operation = new Endpoint(opName, epName);
            Builder.addServiceEP(dataService, opName, epName);
        }
    }
}

