/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.authz;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.jena.fuseki.authz.AuthorizationFilter403;

public class LocalhostFilter
extends AuthorizationFilter403 {
    private static final String message = "Access denied : only localhost access allowed";
    private static String LOCALHOST_IpV6 = "0:0:0:0:0:0:0:1";
    private static String LOCALHOST_IpV4 = "127.0.0.1";

    public LocalhostFilter() {
        super(message);
    }

    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        String remoteAddr = request.getRemoteAddr();
        return LOCALHOST_IpV6.equals(remoteAddr) || LOCALHOST_IpV4.equals(remoteAddr);
    }
}

